/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geode.management.internal.cli.Completion;
import org.apache.geode.management.internal.cli.CompletionContext;
import org.apache.geode.management.internal.cli.completion.BooleanCompletionProvider;
import org.apache.geode.management.internal.cli.completion.EnumCompletionProvider;
import org.apache.geode.management.internal.cli.completion.HelpCommandCompletionProvider;
import org.apache.geode.management.internal.cli.completion.HintTopicCompletionProvider;
import org.apache.geode.management.internal.cli.completion.IndexTypeCompletionProvider;
import org.apache.geode.management.internal.cli.completion.LogLevelCompletionProvider;
import org.apache.geode.management.internal.cli.completion.ValueCompletionProvider;

public class CompletionProviderRegistry {
    private final List<ValueCompletionProvider> providers = new ArrayList<ValueCompletionProvider>();

    public CompletionProviderRegistry() {
        this.registerProvider(new IndexTypeCompletionProvider());
        this.registerProvider(new EnumCompletionProvider());
        this.registerProvider(new BooleanCompletionProvider());
        this.registerProvider(new HintTopicCompletionProvider());
        this.registerProvider(new HelpCommandCompletionProvider());
        this.registerProvider(new LogLevelCompletionProvider());
    }

    public void registerProvider(ValueCompletionProvider provider) {
        this.providers.add(provider);
    }

    public ValueCompletionProvider findProvider(Class<?> targetType) {
        for (ValueCompletionProvider provider : this.providers) {
            if (!provider.supports(targetType)) continue;
            return provider;
        }
        return null;
    }

    public List<Completion> getCompletions(Class<?> targetType, String partialValue, CompletionContext context) {
        for (ValueCompletionProvider provider : this.providers) {
            List<Completion> completions;
            if (!provider.supports(targetType) || (completions = provider.getCompletions(targetType, partialValue, context)) == null || completions.isEmpty()) continue;
            return completions;
        }
        return Collections.emptyList();
    }

    public int getProviderCount() {
        return this.providers.size();
    }
}

