/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.internal.Assert;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class StartPulseCommand
extends OfflineGfshCommand {
    @ShellMethod(value="Open a new window in the default Web browser with the URL for the Pulse application.", key={"start pulse"})
    @CliMetaData(shellOnly=true, relatedTopic={"Manager", "JMX", "Management-Monitoring"})
    public ResultModel startPulse(@ShellOption(value={"url"}, defaultValue="http://localhost:7070/pulse", help="URL of the Pulse Web application.") String url) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String validatedUrl = this.validateAndSanitizeUrlString(url);
            this.browse(URI.create(validatedUrl));
            return ResultModel.createInfo("Launched Geode Pulse");
        }
        if (this.isConnectedAndReady()) {
            ObjectName managerObjectName;
            OperationInvoker operationInvoker = this.getGfsh().getOperationInvoker();
            String pulseURL = (String)operationInvoker.getAttribute((managerObjectName = (ObjectName)operationInvoker.getAttribute("GemFire:service=System,type=Distributed", "ManagerObjectName")).toString(), "PulseURL");
            if (StringUtils.isNotBlank((CharSequence)pulseURL)) {
                String validatedPulseUrl = this.validateAndSanitizeUrlString(pulseURL);
                this.browse(URI.create(validatedPulseUrl));
                return ResultModel.createError("Launched Geode Pulse with URL: " + validatedPulseUrl);
            }
            String pulseMessage = (String)operationInvoker.getAttribute(managerObjectName.toString(), "StatusMessage");
            return StringUtils.isNotBlank((CharSequence)pulseMessage) ? ResultModel.createError(pulseMessage) : ResultModel.createError("Could not find the URL for Geode Pulse.");
        }
        return ResultModel.createError(CliStrings.format((String)"Gfsh must be connected for launching {0}", (Object)"GemFire Pulse"));
    }

    private void browse(URI uri) throws IOException {
        this.validatePulseUri(uri);
        Assert.assertState((boolean)Desktop.isDesktopSupported(), (String)String.format("Running desktop applications is not supported on %1$s.", System.getProperty("os.name")), (Object[])new Object[0]);
        Desktop.getDesktop().browse(uri);
    }

    private void validatePulseUri(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("URI must have a scheme (protocol)");
        }
        if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("Invalid URL protocol: " + scheme + ". Only HTTP and HTTPS are allowed for Pulse URLs.");
        }
        String host = uri.getHost();
        if (host == null) {
            throw new IllegalArgumentException("URI must have a valid host");
        }
        if (!this.isValidPulseHost(host)) {
            throw new IllegalArgumentException("Invalid host for Pulse URL: " + host + ". Only localhost and configured hosts are allowed.");
        }
    }

    private boolean isValidPulseHost(String host) {
        if (host.equalsIgnoreCase("localhost") || host.equals("127.0.0.1") || host.equals("::1")) {
            return true;
        }
        return host.matches("^[a-zA-Z0-9][a-zA-Z0-9.-]*[a-zA-Z0-9]$") && host.length() <= 253 && !host.contains("..");
    }

    private String validateAndSanitizeUrlString(String urlString) {
        if (urlString == null || urlString.trim().isEmpty()) {
            throw new IllegalArgumentException("URL cannot be null or empty");
        }
        String normalizedUrl = urlString.trim();
        if (normalizedUrl.contains("\n") || normalizedUrl.contains("\r") || normalizedUrl.contains("\t") || normalizedUrl.contains(" ")) {
            throw new IllegalArgumentException("URL contains invalid characters");
        }
        if (!normalizedUrl.toLowerCase().startsWith("http://") && !normalizedUrl.toLowerCase().startsWith("https://")) {
            throw new IllegalArgumentException("URL must start with http:// or https://. Got: " + normalizedUrl.substring(0, Math.min(20, normalizedUrl.length())));
        }
        if (normalizedUrl.toLowerCase().contains("javascript:") || normalizedUrl.toLowerCase().contains("vbscript:") || normalizedUrl.toLowerCase().contains("data:") || normalizedUrl.toLowerCase().contains("file:")) {
            throw new IllegalArgumentException("URL contains dangerous protocol");
        }
        try {
            URI tempUri = URI.create(normalizedUrl);
            this.validatePulseUri(tempUri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URL format: " + e.getMessage());
        }
        return normalizedUrl;
    }
}

