/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.functions.FetchSharedConfigurationStatusFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.configuration.domain.SharedConfigurationStatus;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;

public class StatusClusterConfigServiceCommand
extends GfshCommand {
    @ShellMethod(value="Displays the status of cluster configuration service on all the locators with enable-cluster-configuration set to true.", key={"status cluster-config-service"})
    @CliMetaData(relatedTopic={"Locator"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel statusSharedConfiguration() {
        InternalCache cache = (InternalCache)this.getCache();
        HashSet<DistributedMember> locators = new HashSet<DistributedMember>(cache.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration().keySet());
        if (locators.isEmpty()) {
            return ResultModel.createInfo("No locators found with \"enable-cluster-configuration=true\".");
        }
        ResultModel resultModel = new ResultModel();
        TabularResultModel tabularResultModel = resultModel.addTable("Status of shared configuration on locators");
        if (!this.populateSharedConfigurationStatus(locators, tabularResultModel)) {
            resultModel.setStatus(Result.Status.ERROR);
        }
        return resultModel;
    }

    private boolean populateSharedConfigurationStatus(Set<DistributedMember> locators, TabularResultModel tabularResultModel) {
        boolean isSharedConfigRunning = false;
        ResultCollector rc = ManagementUtils.executeFunction((Function)new FetchSharedConfigurationStatusFunction(), null, locators);
        List results = (List)rc.getResult();
        for (CliFunctionResult result : results) {
            tabularResultModel.accumulate("Name", result.getMemberIdOrName());
            String status = (String)result.getResultObject();
            tabularResultModel.accumulate("Status", status);
            if (!SharedConfigurationStatus.RUNNING.name().equals(status)) continue;
            isSharedConfigRunning = true;
        }
        return isSharedConfigRunning;
    }
}

