/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class ShowLogCommand
extends GfshCommand {
    @ShellMethod(value="Display the log for a member.", key={"show log"})
    @CliMetaData(relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel showLog(@ShellOption(value={"member"}, help="Name/Id of the member whose log file will be displayed.") String memberNameOrId, @ShellOption(value={"lines"}, defaultValue="0", help="Number of lines from the log file to display. The maximum is 100.") int numberOfLines) {
        DistributedMember targetMember = this.getMember(memberNameOrId);
        MemberMXBean targetMemberMXBean = this.getMemberMxBean(targetMember);
        if (numberOfLines > 100) {
            numberOfLines = 100;
        }
        if (numberOfLines == 0 || numberOfLines < 0) {
            numberOfLines = 30;
        }
        ResultModel result = new ResultModel();
        InfoResultModel resultInfo = result.addInfo();
        if (targetMemberMXBean != null) {
            String log = targetMemberMXBean.showLog(numberOfLines);
            if (log != null) {
                resultInfo.addLine(log);
            } else {
                resultInfo.addLine("There is no log for this member");
            }
        } else {
            return ResultModel.createError(String.format("%s: %s", "Member not found", memberNameOrId));
        }
        return result;
    }

    public MemberMXBean getMemberMxBean(DistributedMember targetMember) {
        SystemManagementService service = (SystemManagementService)this.getManagementService();
        if (this.getCache().getDistributedSystem().getDistributedMember().equals(targetMember)) {
            return service.getMemberMXBean();
        }
        ObjectName objectName = service.getMemberMBeanName(targetMember);
        return (MemberMXBean)service.getMBeanProxy(objectName, MemberMXBean.class);
    }
}

