/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.cache.Cache;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class RevokeMissingDiskStoreCommand
extends GfshCommand {
    @ShellMethod(value="Instructs the member(s) of a distributed system to stop waiting for a disk store to be available. Only revoke a disk store if its files are lost as it will no longer be recoverable once revoking is initiated. Use the \"show missing-disk-store\" command to get descriptions of missing disk stores.", key={"revoke missing-disk-store"})
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DISK)
    public ResultModel revokeMissingDiskStore(@ShellOption(value={"id"}, help="ID of the missing disk store to be revoked.") String id) {
        DistributedSystemMXBean dsMXBean = ManagementService.getManagementService((Cache)this.getCache()).getDistributedSystemMXBean();
        if (dsMXBean.revokeMissingDiskStores(id)) {
            return ResultModel.createInfo("Missing disk store successfully revoked");
        }
        return ResultModel.createError("Unable to find missing disk store to revoke");
    }
}

