/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.commands.DataCommandsUtils;
import org.apache.geode.management.internal.cli.domain.DataCommandRequest;
import org.apache.geode.management.internal.cli.domain.DataCommandResult;
import org.apache.geode.management.internal.cli.functions.DataCommandFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class RemoveCommand
extends GfshCommand {
    public static final String REGION_NOT_FOUND = "Region <%s> not found in any of the members";

    @CliMetaData(relatedTopic={"Data", "Region"})
    @ShellMethod(value="Remove an entry from a region. If using a region whose key class has been set, then specifying --key-class is unnecessary.", key={"remove"})
    public ResultModel remove(@ShellOption(value={"region"}, help="Region from which to remove the entry.") String regionPath, @ShellOption(value={"key"}, help="String or JSON text from which to create the key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".") String key, @ShellOption(value={"all"}, help="Clears the region by removing all entries. Partitioned region does not support remove-all", defaultValue="false") boolean removeAllKeys, @ShellOption(value={"key-class"}, help="Fully qualified class name of the key's type. The default is the key constraint for the current region or String.") String keyClass) {
        DataCommandResult dataResult;
        Cache cache = this.getCache();
        if (!removeAllKeys && key == null) {
            return ResultModel.createError("Key is Null");
        }
        if (removeAllKeys) {
            this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionPath);
        } else {
            this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionPath, key);
        }
        key = DataCommandsUtils.makeBrokenJsonCompliant(key);
        Region region = cache.getRegion(regionPath);
        DataCommandFunction removefn = new DataCommandFunction();
        if (region == null) {
            Set<DistributedMember> memberList = this.findAnyMembersForRegion(regionPath);
            if (CollectionUtils.isEmpty(memberList)) {
                return ResultModel.createError(String.format(REGION_NOT_FOUND, regionPath));
            }
            DataCommandRequest request = new DataCommandRequest();
            request.setCommand("remove");
            request.setKey(key);
            request.setKeyClass(keyClass);
            request.setRemoveAllKeys(removeAllKeys ? "ALL" : null);
            request.setRegionName(regionPath);
            dataResult = DataCommandsUtils.callFunctionForRegion(request, removefn, memberList);
        } else {
            dataResult = removefn.remove(key, keyClass, regionPath, removeAllKeys ? "ALL" : null, (InternalCache)cache);
        }
        dataResult.setKeyClass(keyClass);
        return dataResult.toResultModel();
    }
}

