/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;

public class QueryInterceptor
extends AbstractCliAroundInterceptor {
    public static final String FILE_ALREADY_EXISTS_MESSAGE = "The specified output file already exists.";

    @Override
    public ResultModel preExecution(GfshParseResult parseResult) {
        String query = parseResult.getParamValueAsString("query");
        String file = parseResult.getParamValueAsString("file");
        String interactive = parseResult.getParamValueAsString("interactive");
        String member = parseResult.getParamValueAsString("member");
        boolean hasQuery = StringUtils.isNotBlank((CharSequence)query);
        boolean hasFile = StringUtils.isNotBlank((CharSequence)file);
        boolean hasInteractive = "true".equalsIgnoreCase(interactive);
        boolean hasMember = StringUtils.isNotBlank((CharSequence)member);
        if (!(hasQuery || hasFile || hasInteractive || hasMember)) {
            return ResultModel.createError("You should specify option (--query, --file, --interactive, --member) for this command");
        }
        File outputFile = this.getOutputFile(parseResult);
        if (outputFile != null && outputFile.exists()) {
            return ResultModel.createError(FILE_ALREADY_EXISTS_MESSAGE);
        }
        return new ResultModel();
    }

    @Override
    public ResultModel postExecution(GfshParseResult parseResult, ResultModel model, Path tempFile) throws Exception {
        File outputFile = this.getOutputFile(parseResult);
        if (outputFile == null) {
            return model;
        }
        Object sectionResultData = model.getDataSection("data-info").getContent();
        String limit = (String)sectionResultData.get("Limit");
        String resultString = (String)sectionResultData.get("Result");
        String rows = (String)sectionResultData.get("Rows");
        if ("false".equalsIgnoreCase(resultString)) {
            return model;
        }
        this.writeResultTableToFile(outputFile, model);
        ResultModel newModel = new ResultModel();
        DataResultModel data = newModel.addData("data-info");
        data.addData("Result", resultString);
        if (StringUtils.isNotBlank((CharSequence)limit)) {
            data.addData("Limit", limit);
        }
        data.addData("Rows", rows);
        newModel.addInfo().addLine("Query results output to " + outputFile.getAbsolutePath());
        return newModel;
    }

    private File getOutputFile(GfshParseResult parseResult) {
        String outputFilePath = parseResult.getParamValueAsString("file");
        if (StringUtils.isBlank((CharSequence)outputFilePath)) {
            return null;
        }
        return new File(outputFilePath);
    }

    private void writeResultTableToFile(File file, ResultModel resultModel) throws IOException {
        CommandResult commandResult = new CommandResult(resultModel);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(commandResult.asString());
        }
    }
}

