/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.ListJndiBindingFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;

public class ListJndiBindingCommand
extends GfshCommand {
    public static final String LIST_JNDIBINDING = "list jndi-binding";
    private static final String LIST_JNDIBINDING__HELP = "List all jndi bindings, active and configured. An active binding is one that is bound to the server's jndi context (and also listed in the cluster config). A configured binding is one that is listed in the cluster config, but may not be active on the servers.";
    @Immutable
    private static final ListJndiBindingFunction LIST_BINDING_FUNCTION = new ListJndiBindingFunction();

    @ShellMethod(value="List all jndi bindings, active and configured. An active binding is one that is bound to the server's jndi context (and also listed in the cluster config). A configured binding is one that is listed in the cluster config, but may not be active on the servers.", key={"list jndi-binding"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel listJndiBinding() {
        Set<DistributedMember> members;
        ResultModel resultModel = new ResultModel();
        TabularResultModel configTable = null;
        InternalConfigurationPersistenceService ccService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (ccService != null) {
            configTable = resultModel.addTable("clusterConfiguration");
            CacheConfig cacheConfig = ccService.getCacheConfig("cluster");
            List jndiBindings = cacheConfig.getJndiBindings();
            if (jndiBindings.size() == 0) {
                configTable.setHeader("No JNDI-bindings found in cluster configuration");
            } else {
                configTable.setHeader("Configured JNDI bindings: ");
                for (JndiBindingsType.JndiBinding jndiBinding : jndiBindings) {
                    configTable.accumulate("Group Name", "cluster");
                    configTable.accumulate("JNDI Name", jndiBinding.getJndiName());
                    configTable.accumulate("JDBC Driver Class", jndiBinding.getJdbcDriverClass());
                }
            }
        }
        if ((members = this.findMembers(null, null)).size() == 0) {
            if (configTable == null) {
                return ResultModel.createError("No members found");
            }
            configTable.setFooter("No members found");
            return resultModel;
        }
        TabularResultModel memberTable = resultModel.addTable("memberConfiguration");
        List<CliFunctionResult> rc = this.executeAndGetFunctionResult((Function<?>)LIST_BINDING_FUNCTION, null, members);
        memberTable.setHeader("Active JNDI bindings found on each member: ");
        for (CliFunctionResult oneResult : rc) {
            Serializable[] serializables = this.getSerializables(oneResult);
            for (int i = 0; i < serializables.length - 1; i += 2) {
                memberTable.accumulate("Member", oneResult.getMemberIdOrName());
                memberTable.accumulate("JNDI Name", (String)((Object)serializables[i]));
                memberTable.accumulate("JDBC Driver Class", (String)((Object)serializables[i + 1]));
            }
        }
        return resultModel;
    }

    private Serializable[] getSerializables(CliFunctionResult oneResult) {
        return oneResult.getSerializables();
    }
}

