/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.functions.ListDurableCqNamesFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class ListDurableClientCQsCommand
extends GfshCommand {
    @ShellMethod(value="List durable client cqs associated with the specified durable client id.", key={"list durable-cqs"})
    @CliMetaData
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel listDurableClientCQs(@ShellOption(value={"durable-client-id"}, help="The id used to identify the durable client") String durableClientId, @ShellOption(value={"member", "members"}, help="Name/Id of the member for which the durable client is registered and durable cqs will be displayed.") String[] memberNameOrId, @ShellOption(value={"group", "groups"}, help="Group of members for which the durable client is registered and durable cqs will be displayed.") String[] group) {
        Set<DistributedMember> targetMembers = this.findMembers(group, memberNameOrId);
        if (targetMembers.isEmpty()) {
            return ResultModel.createInfo("No Members Found");
        }
        ResultCollector<?, ?> rc = this.executeFunction((Function<?>)new ListDurableCqNamesFunction(), (Object)durableClientId, targetMembers);
        List results = (List)rc.getResult();
        ResultModel result = new ResultModel();
        TabularResultModel table = result.addTable("list-durable-client-cqs");
        for (List perMemberList : results) {
            for (CliFunctionResult oneResult : perMemberList) {
                table.accumulate("Member", oneResult.getMemberIdOrName());
                table.accumulate("Status", oneResult.getStatus());
                table.accumulate("CQ Name", oneResult.getStatusMessage());
                if (oneResult.isSuccessful() || oneResult.isIgnorableFailure()) continue;
                result.setStatus(Result.Status.ERROR);
            }
        }
        return result;
    }
}

