/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.functions.GarbageCollectionFunction;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class GCCommand
extends GfshCommand {
    @ShellMethod(value="Force GC (Garbage Collection) on a member or members. The default is for garbage collection to occur on all caching members.", key={"gc"})
    @CliMetaData(relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel gc(@ShellOption(value={"group", "groups"}, help="Group(s) of members on which garbage collection will be done.") String[] groups, @ShellOption(value={"member"}, help="Name/Id of the member on which garbage collection will be done.") String memberId) {
        Cache cache = this.getCache();
        ResultModel result = new ResultModel();
        TabularResultModel summary = result.addTable("summary");
        InfoResultModel errors = result.addInfo("errors");
        String headerText = "GC Summary";
        summary.setHeader(headerText);
        Set<Object> dsMembers = new HashSet();
        if (memberId != null && memberId.length() > 0) {
            String[] member = this.getMember(memberId);
            dsMembers.add(member);
        } else if (groups != null && groups.length > 0) {
            for (String group : groups) {
                dsMembers.addAll(cache.getDistributedSystem().getGroupMembers(group));
            }
        } else {
            dsMembers = this.getAllNormalMembers();
        }
        GarbageCollectionFunction garbageCollectionFunction = new GarbageCollectionFunction();
        List resultList = (List)ManagementUtils.executeFunction((Function)garbageCollectionFunction, null, dsMembers).getResult();
        for (Object object : resultList) {
            if (object == null) {
                errors.addLine("ResultMap was null");
                continue;
            }
            if (object instanceof Throwable) {
                errors.addLine("Exception in GC " + ((Throwable)object).getMessage());
                LogWrapper.getInstance(this.getCache()).fine("Exception in GC " + ((Throwable)object).getMessage(), (Throwable)object);
                continue;
            }
            if (object instanceof String) {
                errors.addLine((String)object);
                continue;
            }
            Map resultMap = (Map)object;
            summary.accumulate("Member ID/Name", (String)resultMap.get("MemberId"));
            summary.accumulate("HeapSize (MB) Before GC", (String)resultMap.get("HeapSizeBeforeGC"));
            summary.accumulate("HeapSize(MB) After GC", (String)resultMap.get("HeapSizeAfterGC"));
            summary.accumulate("Time Taken for GC in ms", (String)resultMap.get("TimeSpentInGC"));
        }
        return result;
    }
}

