/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.functions.ExportConfigFunction;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class ExportConfigCommand
extends GfshCommand {
    private final ExportConfigFunction exportConfigFunction = new ExportConfigFunction();

    @ShellMethod(value="Export configuration properties for a member or members.", key={"export config"})
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.ExportConfigCommand$Interceptor", relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel exportConfig(@ShellOption(value={"member", "members"}, help="Name/Id of the member(s) whose configuration will be exported.") String[] member, @ShellOption(value={"group", "groups"}, help="Group(s) of members whose configuration will be exported.") String[] group, @ShellOption(value={"dir"}, help="Directory to which the exported configuration files will be written.") String dir) {
        ResultModel crm = new ResultModel();
        InfoResultModel infoData = crm.addInfo("info");
        Set<DistributedMember> targetMembers = this.findMembers(group, member);
        if (targetMembers.isEmpty()) {
            ResultModel.createError("No Members Found");
            return crm;
        }
        ResultCollector rc = ManagementUtils.executeFunction((Function)this.exportConfigFunction, null, targetMembers);
        List results = CliFunctionResult.cleanResults((List)((List)rc.getResult()));
        for (CliFunctionResult result : results) {
            if (result.getThrowable() != null) {
                infoData.addLine(CliStrings.format((String)"Exception while exporting config: {0}", (Object[])new Object[]{result.getMemberIdOrName(), result.getThrowable()}));
                continue;
            }
            if (!result.isSuccessful()) continue;
            String cacheFileName = result.getMemberIdOrName() + "-cache.xml";
            String propsFileName = result.getMemberIdOrName() + "-gf.properties";
            String[] fileContent = (String[])result.getSerializables();
            crm.addFile(cacheFileName, fileContent[0]);
            crm.addFile(propsFileName, fileContent[1]);
        }
        return crm;
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        private File saveDirFile;

        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            String dir = parseResult.getParamValueAsString("dir");
            if (StringUtils.isBlank((CharSequence)dir)) {
                this.saveDirFile = new File(".").getAbsoluteFile();
                return new ResultModel();
            }
            this.saveDirFile = new File(dir.trim()).getAbsoluteFile();
            if (!this.saveDirFile.exists() && !this.saveDirFile.mkdirs()) {
                return ResultModel.createError(CliStrings.format((String)"Directory {0} could not be created", (Object)dir));
            }
            if (!this.saveDirFile.isDirectory()) {
                return ResultModel.createError(CliStrings.format((String)"{0} is not a directory", (Object)dir));
            }
            try {
                if (!this.saveDirFile.canWrite()) {
                    return ResultModel.createError(CliStrings.format((String)"{0} is not writeable", (Object)this.saveDirFile.getCanonicalPath()));
                }
            }
            catch (IOException ioex) {
                return ResultModel.createError(CliStrings.format((String)"{0} is not writeable", (Object)this.saveDirFile.getName()));
            }
            return new ResultModel();
        }

        @Override
        public ResultModel postExecution(GfshParseResult parseResult, ResultModel commandResult, Path tempFile) throws Exception {
            commandResult.saveFileTo(this.saveDirFile);
            return commandResult;
        }
    }
}

