/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.RegionDestroyFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class DestroyRegionCommand
extends GfshCommand {
    @ShellMethod(value="Destroy/Remove a region.", key={"destroy region"})
    @CliMetaData(relatedTopic={"Region"}, interceptor="org.apache.geode.management.internal.cli.MandatoryParameterValidationInterceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel destroyRegion(@ShellOption(value={"name"}, help="Name/Path of the region to be removed.") String regionPath, @ShellOption(value={"if-exists"}, help="If true, the command will be a no-op if the entity does not exist.", defaultValue="false") boolean ifExists) {
        if (regionPath == null || regionPath.trim().isEmpty()) {
            return ResultModel.createError("Invalid command");
        }
        Set<DistributedMember> regionMembersList = this.findMembersForRegion(regionPath);
        if (regionMembersList.size() == 0) {
            String message = CliStrings.format((String)"Could not find a Region with Region path \"{0}\" in this Geode cluster. If region was recently created, please wait for at least {1} to allow the associated Management resources to be federated.", (Object[])new Object[]{regionPath, "jmx-manager-update-rate milliseconds"});
            throw new EntityNotFoundException(message, ifExists);
        }
        try {
            this.checkForJDBCMapping(regionPath);
        }
        catch (IllegalStateException e) {
            return ResultModel.createError(e.getMessage());
        }
        List<CliFunctionResult> resultsList = this.executeAndGetFunctionResult((Function<?>)RegionDestroyFunction.INSTANCE, regionPath, regionMembersList);
        ResultModel result = ResultModel.createMemberStatusResult(resultsList);
        XmlEntity xmlEntity = this.findXmlEntity(resultsList);
        InternalConfigurationPersistenceService configurationPersistenceService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (xmlEntity != null) {
            if (configurationPersistenceService == null) {
                result.addInfo().addLine("Cluster configuration service is not running. Configuration change is not persisted.");
            } else {
                configurationPersistenceService.deleteXmlEntity(xmlEntity, null);
            }
        }
        return result;
    }

    private XmlEntity findXmlEntity(List<CliFunctionResult> functionResults) {
        return functionResults.stream().filter(CliFunctionResult::isSuccessful).map(CliFunctionResult::getXmlEntity).filter(Objects::nonNull).findFirst().orElse(null);
    }

    void checkForJDBCMapping(String regionPath) {
        InternalConfigurationPersistenceService ccService;
        String regionName = regionPath;
        if (regionPath.startsWith("/")) {
            regionName = regionPath.substring(1);
        }
        if ((ccService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService()) == null) {
            return;
        }
        HashSet<String> groupNames = new HashSet<String>(ccService.getGroups());
        groupNames.add("cluster");
        for (String groupName : groupNames) {
            Identifiable element;
            RegionConfig regionConfig;
            CacheConfig cacheConfig = ccService.getCacheConfig(groupName);
            if (cacheConfig == null || (regionConfig = (RegionConfig)Identifiable.find((List)cacheConfig.getRegions(), (String)regionName)) == null || (element = Identifiable.find((List)regionConfig.getCustomRegionElements(), (String)"jdbc-mapping")) == null) continue;
            throw new IllegalStateException("Cannot destroy region \"" + regionName + "\" because JDBC mapping exists. Use \"destroy jdbc-mapping\" first.");
        }
    }
}

