/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.commands.CreateGatewaySenderCommand;
import org.apache.geode.management.internal.cli.functions.GatewaySenderDestroyFunction;
import org.apache.geode.management.internal.cli.functions.GatewaySenderDestroyFunctionArgs;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class DestroyGatewaySenderCommand
extends SingleGfshCommand {
    private static final Logger logger = LogService.getLogger();
    private static final int MBEAN_DELETION_WAIT_TIME = 10000;

    @ShellMethod(value="Destroy the Gateway Sender on a member or members.", key={"destroy gateway-sender"})
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public ResultModel destroyGatewaySender(@ShellOption(value={"id"}, help="Id of the GatewaySender.") String id, @ShellOption(value={"group", "groups"}, help="Group(s) of members on which to destroy the Gateway Sender.") String[] onGroups, @ShellOption(value={"member", "members"}, help="Name/Id of the member on which to destroy the Gateway Sender.") String[] onMember, @ShellOption(value={"if-exists"}, help="If true, the command will be a no-op if the entity does not exist.", defaultValue="false") boolean ifExist) {
        if (id == null) {
            return ResultModel.createError("You must specify a gateway sender id.");
        }
        GatewaySenderDestroyFunctionArgs gatewaySenderDestroyFunctionArgs = new GatewaySenderDestroyFunctionArgs(id, ifExist);
        Set<DistributedMember> members = this.getMembers(onGroups, onMember);
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult((Function<?>)GatewaySenderDestroyFunction.INSTANCE, gatewaySenderDestroyFunctionArgs, members);
        ResultModel resultModel = ResultModel.createMemberStatusResult(functionResults);
        resultModel.setConfigObject(id);
        if (!this.waitForGatewaySenderMBeanDeletion(id, members)) {
            resultModel.addInfo().addLine("Did not complete waiting for GatewaySenderMBean proxy deletion");
        }
        return resultModel;
    }

    @VisibleForTesting
    boolean waitForGatewaySenderMBeanDeletion(String id, Set<DistributedMember> members) {
        DistributedSystemMXBean dsMXBean = this.getManagementService().getDistributedSystemMXBean();
        return this.poll(10000L, TimeUnit.MILLISECONDS, () -> members.stream().noneMatch(m -> CreateGatewaySenderCommand.gatewaySenderBeanExists(dsMXBean, m.getName(), id)));
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object id) {
        config.getGatewaySenders().removeIf(sender -> sender.getId().equals(id));
        return true;
    }
}

