/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.GatewayReceiverConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.functions.DestroyGatewayReceiverFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class DestroyGatewayReceiverCommand
extends SingleGfshCommand {
    public static final String DESTROY_GATEWAYRECEIVER = "destroy gateway-receiver";
    public static final String DESTROY_GATEWAYRECEIVER__HELP = "Destroy the Gateway Receiver on a member or members.";
    public static final String DESTROY_GATEWAYRECEIVER__GROUP__HELP = "Group(s) of members on which to destroy the Gateway Receiver.";
    public static final String DESTROY_GATEWAYRECEIVER__MEMBER__HELP = "Name/Id of the member on which to destroy the Gateway Receiver.";

    @ShellMethod(value="Destroy the Gateway Receiver on a member or members.", key={"destroy gateway-receiver"})
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public ResultModel destroyGatewayReceiver(@ShellOption(value={"group", "groups"}, help="Group(s) of members on which to destroy the Gateway Receiver.") String[] onGroups, @ShellOption(value={"member", "members"}, help="Name/Id of the member on which to destroy the Gateway Receiver.") String[] onMember, @ShellOption(value={"if-exists"}, help="If true, the command will be a no-op if the entity does not exist.", defaultValue="false") boolean ifExists) {
        boolean persisted = true;
        Set<DistributedMember> members = this.getMembers(onGroups, onMember);
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult((Function<?>)DestroyGatewayReceiverFunction.INSTANCE, null, members);
        ResultModel result = ResultModel.createMemberStatusResult(functionResults, ifExists);
        result.setConfigObject(new GatewayReceiverConfig());
        return result;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object element) {
        if (config.getGatewayReceiver() != null) {
            config.setGatewayReceiver(null);
            return true;
        }
        return false;
    }
}

