/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.ClassNameType;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.EnumActionDestroyOverflow;
import org.apache.geode.cache.configuration.RegionAttributesScope;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.config.JAXBService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.configuration.ClassName;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.commands.RegionCommandsUtils;
import org.apache.geode.management.internal.cli.functions.CreateRegionFunctionArgs;
import org.apache.geode.management.internal.cli.functions.FetchRegionAttributesFunction;
import org.apache.geode.management.internal.cli.functions.RegionCreateFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.configuration.converters.RegionConverter;
import org.apache.geode.management.internal.exceptions.EntityExistsException;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.management.internal.util.RegionPath;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class CreateRegionCommand
extends SingleGfshCommand {
    private static final String[] PARTITION_ATTRIBUTES = new String[]{"colocated-with", "local-max-memory", "recovery-delay", "redundant-copies", "startup-recovery-delay", "total-max-memory", "total-num-buckets", "partition-listener", "partition-resolver"};

    @ShellMethod(value="Create a region with the given path and configuration. Specifying a --key-constraint and --value-constraint makes object type information available during querying and indexing.", key={"create region"})
    @CliMetaData(relatedTopic={"Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel createRegion(@ShellOption(value={"name"}, help="Name/Path of the region to be created.") String regionPath, @ShellOption(value={"type"}, help="Type of region to create. The following types are pre-defined by the product (see RegionShortcut javadocs for more information): PARTITION, PARTITION_REDUNDANT, PARTITION_PERSISTENT, PARTITION_REDUNDANT_PERSISTENT, PARTITION_OVERFLOW, PARTITION_REDUNDANT_OVERFLOW, PARTITION_PERSISTENT_OVERFLOW, PARTITION_REDUNDANT_PERSISTENT_OVERFLOW, PARTITION_HEAP_LRU, PARTITION_REDUNDANT_HEAP_LRU, REPLICATE, REPLICATE_PERSISTENT, REPLICATE_OVERFLOW, REPLICATE_PERSISTENT_OVERFLOW, REPLICATE_HEAP_LRU, LOCAL, LOCAL_PERSISTENT, LOCAL_HEAP_LRU, LOCAL_OVERFLOW, LOCAL_PERSISTENT_OVERFLOW, PARTITION_PROXY, PARTITION_PROXY_REDUNDANT, and REPLICATE_PROXY.") RegionShortcut regionShortcut, @ShellOption(value={"template-region"}, help="Name/Path of the region whose attributes should be duplicated when creating this region. Deprecated: Since Geode 1.5, regions should be created explicitly so that undesirable attributes are not copied inadvertently.") String templateRegion, @ShellOption(value={"group", "groups"}, help="Group(s) of members on which the region will be created.") String[] groups, @ShellOption(value={"if-not-exists", "skip-if-exists"}, defaultValue="false", help="By default, an attempt to create a duplicate region is reported as an error. If this option is specified without a value or is specified with a value of true, then gfsh displays a \"Skipping...\" acknowledgement, but does not throw an error. Deprecated: the alias --skip-if-exists is deprecated since Geode 1.5.") boolean ifNotExists, @ShellOption(value={"async-event-queue-id"}, help="IDs of the Async Event Queues that will be used for write-behind operations.") String[] asyncEventQueueIds, @ShellOption(value={"cache-listener"}, help="Fully qualified class name of a plug-in to be instantiated for receiving after-event notification of changes to the region and its entries. Append json string for initialization properties. Any number of cache listeners can be configured.") ClassName[] cacheListener, @ShellOption(value={"cache-loader"}, help="Fully qualified class name of a plug-in to be instantiated for receiving notification of cache misses in the region. Append json string for initialization properties. At most, one cache loader can be defined in each member for the region. For distributed regions, a cache loader may be invoked remotely from other members that have the region defined.") ClassName cacheLoader, @ShellOption(value={"cache-writer"}, help="Fully qualified class name of a plug-in to be instantiated for receiving before-event notification of changes to the region and its entries. Append json string for initialization properties. The plug-in may cancel the event. At most, one cache writer can be defined in each member for the region.") ClassName cacheWriter, @ShellOption(value={"colocated-with"}, help="Central Region with which this region should be colocated.") String prColocatedWith, @ShellOption(value={"compressor"}, help="The fully-qualified class name of the Compressor to use when compressing region entry values.  The default is no compression.") String compressor, @ShellOption(value={"concurrency-level"}, help="An estimate of the maximum number of application threads that will concurrently access a region entry at one time. This attribute does not apply to partitioned regions.") Integer concurrencyLevel, @ShellOption(value={"disk-store"}, help="Disk Store to be used by this region. \"list disk-store\" can be used to display existing disk stores.") String diskStore, @ShellOption(value={"enable-async-conflation"}, help="Whether to allow aggregation of asynchronous TCP/IP messages sent by the producer member of the region. A false value causes all asynchronous messages to be sent individually.") Boolean enableAsyncConflation, @ShellOption(value={"enable-cloning"}, help="Determines how fromDelta applies deltas to the local cache for delta propagation. When true, the updates are applied to a clone of the value and then the clone is saved to the cache. When false, the value is modified in place in the cache.") Boolean cloningEnabled, @ShellOption(value={"enable-concurrency-checks"}, help="Enables a versioning system that detects concurrent modifications and ensures that region contents are consistent across the distributed system.") Boolean concurrencyChecksEnabled, @ShellOption(value={"enable-multicast"}, help="Enables multicast messaging on the region.  Multicast must also be enabled in the cache distributed system properties.  This is primarily useful for replicated regions that are in all servers.") Boolean mcastEnabled, @ShellOption(value={"enable-statistics"}, help="Whether to gather statistics for the region. Must be true to use expiration on the region.") Boolean statisticsEnabled, @ShellOption(value={"enable-subscription-conflation"}, help="Whether the server should conflate its messages to the client. A false value causes all server-client messages to be sent individually.") Boolean enableSubscriptionConflation, @ShellOption(value={"enable-synchronous-disk"}, help="Whether writes are done synchronously for regions that persist data to disk.") Boolean diskSynchronous, @ShellOption(value={"entry-idle-time-expiration"}, help="How long the region's entries can remain in the cache without being accessed. The default is no expiration of this type.") Integer entryExpirationIdleTime, @ShellOption(value={"entry-idle-time-expiration-action"}, help="Action to be taken on an entry that has exceeded the idle expiration.") ExpirationAction entryExpirationIdleTimeAction, @ShellOption(value={"entry-time-to-live-expiration"}, help="How long the region's entries can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer entryExpirationTTL, @ShellOption(value={"entry-time-to-live-expiration-action"}, help="Action to be taken on an entry that has exceeded the TTL expiration.") ExpirationAction entryExpirationTTLAction, @ShellOption(value={"entry-idle-time-custom-expiry"}, help="The name of the class implementing CustomExpiry for entry idle time. Append json string for initialization properties.") ClassName entryIdleTimeCustomExpiry, @ShellOption(value={"entry-time-to-live-custom-expiry"}, help="The name of the class implementing CustomExpiry for entry time to live. Append json string for initialization properties.") ClassName entryTTLCustomExpiry, @ShellOption(value={"eviction-action"}, help="The eviction action to apply. Must be either 'local-destroy' or 'overflow-to-disk'") String evictionAction, @ShellOption(value={"eviction-entry-count"}, help="Activates LRU eviction based on the region's entry count specified by this value.") Integer evictionEntryCount, @ShellOption(value={"eviction-max-memory"}, help="Activates LRU eviction based on the region's memory usage specified by this value (in megabytes).") Integer evictionMaxMemory, @ShellOption(value={"eviction-object-sizer"}, help="A custom class which implements ObjectSizer in order to perform max memory eviction.") String evictionObjectSizer, @ShellOption(value={"gateway-sender-id"}, help="IDs of the Gateway Senders to which data will be routed.") String[] gatewaySenderIds, @ShellOption(value={"key-constraint"}, help="Fully qualified class name of the objects allowed as region keys. Ensures that keys for region entries are all of the same class.") String keyConstraint, @ShellOption(value={"local-max-memory"}, help="Sets the maximum amount of memory, in megabytes, to be used by the region in this process. (Default: 90% of available heap)") Integer prLocalMaxMemory, @ShellOption(value={"off-heap"}, help="Causes the values of the region to be stored in off-heap memory. The default is on heap.") Boolean offHeap, @ShellOption(value={"partition-listener"}, help="The fully-qualified class name of a partition listener") ClassName[] partitionListener, @ShellOption(value={"partition-resolver"}, help="The fully-qualified class name of the region's partition resolver") String partitionResolver, @ShellOption(value={"region-idle-time-expiration"}, help="How long the region can remain in the cache without being accessed. The default is no expiration of this type.") Integer regionExpirationIdleTime, @ShellOption(value={"region-idle-time-expiration-action"}, help="Action to be taken on a region that has exceeded the idle expiration.") ExpirationAction regionExpirationIdleTimeAction, @ShellOption(value={"region-time-to-live-expiration"}, help="How long the region can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer regionExpirationTTL, @ShellOption(value={"region-time-to-live-expiration-action"}, help="Action to be taken on a region that has exceeded the TTL expiration.") ExpirationAction regionExpirationTTLAction, @ShellOption(value={"recovery-delay"}, help="Sets the delay in milliseconds that existing members will wait before satisfying redundancy after another member crashes. -1 (the default) indicates that redundancy will not be recovered after a failure.") Long prRecoveryDelay, @ShellOption(value={"redundant-copies"}, help="Sets the number of extra copies of buckets desired. Extra copies allow for both high availability in the face of VM departure (intended or unintended) and and load balancing read operations. (Allowed values: 0, 1, 2 and 3)") Integer prRedundantCopies, @ShellOption(value={"startup-recovery-delay"}, help="Sets the delay in milliseconds that new members will wait before satisfying redundancy. -1 indicates that adding new members will not trigger redundancy recovery. The default is to recover redundancy immediately when a new member is added.") Long prStartupRecoveryDelay, @ShellOption(value={"total-max-memory"}, help="Sets the maximum amount of memory, in megabytes, to be used by the region in all processes.") Long prTotalMaxMemory, @ShellOption(value={"total-num-buckets"}, help="Sets the total number of hash buckets to be used by the region in all processes. (Default: 113).") Integer prTotalNumBuckets, @ShellOption(value={"value-constraint"}, help="Fully qualified class name of the objects allowed as region values. If not specified then region values can be of any class.") String valueConstraint, @ShellOption(value={"scope"}, help="Sets the scope of the region. Scope cannot be set for Partitioned regions") RegionAttributesScope scope) {
        Set<DistributedMember> membersToCreateRegionOn;
        RegionAttributesType.EvictionAttributes evictionAttributes;
        List partitionListeners;
        Object normalizedTemplateRegion = templateRegion != null && !templateRegion.isEmpty() && !templateRegion.startsWith("/") ? "/" + templateRegion : templateRegion;
        if (prLocalMaxMemory != null && prLocalMaxMemory < 0) {
            return ResultModel.createError("PartitionAttributes localMaxMemory must not be negative.");
        }
        if (prTotalMaxMemory != null && prTotalMaxMemory <= 0L) {
            return ResultModel.createError("Total size of partition region must be > 0.");
        }
        if (prRedundantCopies != null && (prRedundantCopies < 0 || prRedundantCopies > 3)) {
            return ResultModel.createError(CliStrings.format((String)"redundant-copies \"{0}\" is not valid. It should be one of 0, 1, 2, 3.", (Object[])new Object[]{prRedundantCopies}));
        }
        if (concurrencyLevel != null && concurrencyLevel < 0) {
            return ResultModel.createError(CliStrings.format((String)"Specify positive integer value for concurrency-level.  \"{0}\" is not valid.", (Object[])new Object[]{concurrencyLevel}));
        }
        if (keyConstraint != null && !ClassName.isClassNameValid((String)keyConstraint)) {
            return ResultModel.createError(CliStrings.format((String)"Specify a valid class name for key-constraint. \"{0}\" is not valid.", (Object[])new Object[]{keyConstraint}));
        }
        if (valueConstraint != null && !ClassName.isClassNameValid((String)valueConstraint)) {
            return ResultModel.createError(CliStrings.format((String)"Specify a valid class name for value-constraint. \"{0}\" is not valid.", (Object[])new Object[]{valueConstraint}));
        }
        if (compressor != null && !ClassName.isClassNameValid((String)compressor)) {
            return ResultModel.createError(CliStrings.format((String)"{0} is an invalid Compressor.", (Object[])new Object[]{compressor}));
        }
        if (compressor != null && cloningEnabled != null && !cloningEnabled.booleanValue()) {
            return ResultModel.createError(CliStrings.format((String)"Cannot set enable-cloning to false when compressor is provided", (Object[])new Object[]{compressor}));
        }
        if (diskStore != null && regionShortcut != null && !RegionCommandsUtils.PERSISTENT_OVERFLOW_SHORTCUTS.contains(regionShortcut)) {
            String subMessage = "Only regions with persistence or overflow to disk can specify DiskStore";
            String message = subMessage + ". " + CliStrings.format((String)"Use one of these shortcuts: {0}", (Object[])new Object[]{String.valueOf(RegionCommandsUtils.PERSISTENT_OVERFLOW_SHORTCUTS)});
            return ResultModel.createError(message);
        }
        if (!(entryExpirationIdleTime == null && entryExpirationTTL == null && regionExpirationIdleTime == null && regionExpirationTTL == null && entryExpirationIdleTimeAction == null && entryExpirationTTLAction == null && regionExpirationIdleTimeAction == null && regionExpirationTTLAction == null && entryIdleTimeCustomExpiry == null && entryTTLCustomExpiry == null || statisticsEnabled != null && statisticsEnabled.booleanValue())) {
            return ResultModel.createError("Statistics must be enabled for expiration.");
        }
        if (evictionEntryCount != null && evictionMaxMemory != null) {
            return ResultModel.createError("eviction-max-memory and eviction-entry-count cannot both be specified.");
        }
        if ((evictionEntryCount != null || evictionMaxMemory != null) && evictionAction == null) {
            return ResultModel.createError("eviction-action must be specified.");
        }
        if (evictionObjectSizer != null && evictionEntryCount != null) {
            return ResultModel.createError("eviction-object-sizer cannot be specified with eviction-entry-count");
        }
        if (evictionAction != null && EvictionAction.parseAction((String)evictionAction) == EvictionAction.NONE) {
            return ResultModel.createError("eviction-action must be 'local-destroy' or 'overflow-to-disk'");
        }
        if (scope != null && regionShortcut == null) {
            return ResultModel.createError("Scope cannot be used if --type is not set in the command");
        }
        if (scope != null && !regionShortcut.isReplicate()) {
            return ResultModel.createError("Scope cannot be set on non Replicated region types");
        }
        if (regionShortcut != null && normalizedTemplateRegion != null) {
            return ResultModel.createError("Only one of type & template-region can be specified.");
        }
        if (regionShortcut == null && normalizedTemplateRegion == null) {
            return ResultModel.createError("One of \"type\" or \"template-region\" is required.");
        }
        try {
            this.failIfRegionAlreadyExists(regionPath, regionShortcut, groups);
        }
        catch (EntityExistsException e) {
            return ifNotExists ? ResultModel.createInfo("Skipping: " + e.getMessage()) : ResultModel.createError(e.getMessage());
        }
        InternalCache cache = (InternalCache)this.getCache();
        RegionPath regionPathData = new RegionPath(regionPath);
        if (!regionPathData.isRoot() && !this.regionExists(regionPathData.getParent())) {
            return ResultModel.createError(CliStrings.format((String)"Parent region for \"{0}\" does not exist. ", (Object[])new Object[]{regionPath}));
        }
        RegionConfig regionConfig = new RegionConfig();
        InternalConfigurationPersistenceService persistenceService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (regionShortcut != null) {
            regionConfig.setType(regionShortcut.name());
            regionConfig.setRegionAttributes(new RegionConverter().createRegionAttributesByType(regionShortcut.name()));
            RegionAttributesType regionAttributesType = regionConfig.getRegionAttributes();
            if (scope != null && regionShortcut.isReplicate()) {
                regionAttributesType.setScope(scope);
            }
        } else {
            List<Object> templateRegionConfigs = new ArrayList();
            if (persistenceService != null) {
                templateRegionConfigs = persistenceService.getGroups().stream().flatMap(g -> persistenceService.getCacheConfig(g, true).getRegions().stream()).filter(arg_0 -> CreateRegionCommand.lambda$createRegion$1((String)normalizedTemplateRegion, arg_0)).collect(Collectors.toList());
            } else {
                Set<DistributedMember> regionAssociatedMembers = this.findMembersForRegion((String)normalizedTemplateRegion);
                if (!regionAssociatedMembers.isEmpty()) {
                    List<CliFunctionResult> regionXmlResults = this.executeAndGetFunctionResult((Function<?>)FetchRegionAttributesFunction.INSTANCE, normalizedTemplateRegion, regionAssociatedMembers);
                    JAXBService jaxbService = new JAXBService(new Class[]{CacheConfig.class});
                    templateRegionConfigs = regionXmlResults.stream().filter(CliFunctionResult::isSuccessful).map(CliFunctionResult::getResultObject).map(String.class::cast).map(s -> (RegionConfig)jaxbService.unMarshall(s, RegionConfig.class)).collect(Collectors.toList());
                }
            }
            if (templateRegionConfigs.isEmpty()) {
                return ResultModel.createError("Template region " + (String)normalizedTemplateRegion + " does not exist.");
            }
            if (templateRegionConfigs.size() == 1) {
                regionConfig = (RegionConfig)templateRegionConfigs.get(0);
            } else {
                RegionConfig first = (RegionConfig)templateRegionConfigs.get(0);
                for (int i = 1; i < templateRegionConfigs.size(); ++i) {
                    if (EqualsBuilder.reflectionEquals((Object)first, (Object)templateRegionConfigs.get(i), (boolean)false, null, (boolean)true, (String[])new String[0])) continue;
                    return ResultModel.createError("Multiple types of template region " + (String)normalizedTemplateRegion + " exist. Can not resolve template region attributes.");
                }
                regionConfig = first;
            }
        }
        regionConfig.setName(regionPathData.getName());
        List list = partitionListeners = partitionListener == null ? Collections.emptyList() : Arrays.stream(partitionListener).map(ClassName::getClassName).collect(Collectors.toList());
        String normalizedPrColocatedWith = prColocatedWith != null ? (prColocatedWith.startsWith("/") ? prColocatedWith : "/" + prColocatedWith) : null;
        RegionAttributesType regionAttributes = regionConfig.getRegionAttributes();
        RegionAttributesType.PartitionAttributes delta = RegionAttributesType.PartitionAttributes.generate((String)partitionResolver, partitionListeners, (Integer)prLocalMaxMemory, (Long)prRecoveryDelay, (Integer)prRedundantCopies, (Long)prStartupRecoveryDelay, (Long)prTotalMaxMemory, (Integer)prTotalNumBuckets, (String)normalizedPrColocatedWith);
        RegionAttributesType.PartitionAttributes partitionAttributes = RegionAttributesType.PartitionAttributes.combine((RegionAttributesType.PartitionAttributes)regionAttributes.getPartitionAttributes(), (RegionAttributesType.PartitionAttributes)delta);
        regionAttributes.setPartitionAttributes(partitionAttributes);
        if (!regionAttributes.getDataPolicy().isPartition() && partitionAttributes != null) {
            return ResultModel.createError(String.format("Parameters %s can be used only for creating a Partitioned Region", Strings.join((String[])PARTITION_ATTRIBUTES, (String)", ")));
        }
        if (prColocatedWith != null) {
            Object normalizedColocatedPath = prColocatedWith.startsWith("/") ? prColocatedWith : "/" + prColocatedWith;
            DistributedRegionMXBean colocatedRegionBean = this.getManagementService().getDistributedRegionMXBean((String)normalizedColocatedPath);
            if (colocatedRegionBean == null) {
                return ResultModel.createError(CliStrings.format((String)"Specify a valid region path for {0}. Region {1} not found.", (Object[])new Object[]{"colocated-with", prColocatedWith}));
            }
            if (!colocatedRegionBean.getRegionType().equals("PARTITION") && !colocatedRegionBean.getRegionType().equals("PERSISTENT_PARTITION")) {
                return ResultModel.createError(CliStrings.format((String)"colocated-with \"{0}\" is not a Partitioned Region.", (Object)prColocatedWith));
            }
        }
        if (gatewaySenderIds != null) {
            Set existingGatewaySenders = Arrays.stream(this.getDSMBean().listGatewaySenders()).collect(Collectors.toSet());
            if (existingGatewaySenders.isEmpty()) {
                return ResultModel.createError("There are no GatewaySenders defined currently in the system.");
            }
            if (Arrays.stream(gatewaySenderIds).anyMatch(id -> !existingGatewaySenders.contains(id))) {
                return ResultModel.createError(CliStrings.format((String)"Specify valid gateway-sender-id. Unknown Gateway Sender(s): \"{0}\".", (Object[])gatewaySenderIds));
            }
            regionAttributes.setGatewaySenderIds(StringUtils.join((Object[])gatewaySenderIds, (String)","));
        }
        if ((evictionAttributes = RegionAttributesType.EvictionAttributes.generate((String)evictionAction, (Integer)evictionMaxMemory, (Integer)evictionEntryCount, (String)evictionObjectSizer)) != null) {
            regionAttributes.setEvictionAttributes(evictionAttributes);
        }
        if (diskStore != null) {
            if (regionShortcut != null) {
                if (!regionShortcut.isPersistent() && !regionShortcut.isOverflow()) {
                    String subMessage = "Only regions with persistence or overflow to disk can specify DiskStore";
                    String message = subMessage + ". " + CliStrings.format((String)"Use one of these shortcuts: {0}", (Object[])new Object[]{String.valueOf(RegionCommandsUtils.PERSISTENT_OVERFLOW_SHORTCUTS)});
                    return ResultModel.createError(message);
                }
            } else {
                EnumActionDestroyOverflow tempEvictionAction = EnumActionDestroyOverflow.LOCAL_DESTROY;
                RegionAttributesType.EvictionAttributes tempEvictionAttributes = regionAttributes.getEvictionAttributes();
                if (tempEvictionAttributes != null) {
                    if (tempEvictionAttributes.getLruMemorySize() != null) {
                        tempEvictionAction = tempEvictionAttributes.getLruMemorySize().getAction();
                    } else if (tempEvictionAttributes.getLruEntryCount() != null) {
                        tempEvictionAction = tempEvictionAttributes.getLruEntryCount().getAction();
                    } else if (tempEvictionAttributes.getLruHeapPercentage() != null) {
                        tempEvictionAction = tempEvictionAttributes.getLruHeapPercentage().getAction();
                    }
                }
                if (!regionAttributes.getDataPolicy().isPersistent() && tempEvictionAction != EnumActionDestroyOverflow.OVERFLOW_TO_DISK) {
                    String subMessage = "Only regions with persistence or overflow to disk can specify DiskStore";
                    String message = subMessage + ". " + CliStrings.format((String)"template-region region \"{0}\" is not persistent or overflow to disk.", (Object[])new Object[]{templateRegion});
                    return ResultModel.createError(message);
                }
            }
            if (!this.diskStoreExists(diskStore)) {
                return ResultModel.createError(CliStrings.format((String)"Specify valid disk-store. Unknown Disk Store : \"{0}\".", (Object[])new Object[]{diskStore}));
            }
            regionAttributes.setDiskStoreName(diskStore);
        }
        if (regionAttributes.getDataPolicy().isPersistent()) {
            this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.WRITE, ResourcePermission.Target.DISK);
        }
        if ((membersToCreateRegionOn = this.findMembers(groups, null)).isEmpty()) {
            if (groups == null || groups.length == 0) {
                return ResultModel.createError("No Members Found");
            }
            return ResultModel.createError(CliStrings.format((String)"Group(s) \"{0}\" are invalid.", (Object[])groups));
        }
        if (cacheListener != null) {
            regionAttributes.getCacheListeners().clear();
            Arrays.stream(cacheListener).map(cl -> new DeclarableType(cl.getClassName(), cl.getInitProperties())).forEach(regionAttributes.getCacheListeners()::add);
        }
        if (cacheLoader != null && !cacheLoader.equals((Object)ClassName.EMPTY)) {
            regionAttributes.setCacheLoader(new DeclarableType(cacheLoader.getClassName(), cacheLoader.getInitProperties()));
        }
        if (cacheWriter != null && !cacheWriter.equals((Object)ClassName.EMPTY)) {
            regionAttributes.setCacheWriter(new DeclarableType(cacheWriter.getClassName(), cacheWriter.getInitProperties()));
        }
        if (compressor != null) {
            regionAttributes.setCompressor(new ClassNameType(compressor));
        }
        if (keyConstraint != null) {
            regionAttributes.setKeyConstraint(keyConstraint);
        }
        if (valueConstraint != null) {
            regionAttributes.setValueConstraint(valueConstraint);
        }
        if (asyncEventQueueIds != null) {
            regionAttributes.setAsyncEventQueueIds(Strings.join((String[])asyncEventQueueIds, (String)","));
        }
        if (offHeap != null) {
            regionAttributes.setOffHeap(offHeap);
        }
        if (concurrencyLevel != null) {
            regionAttributes.setConcurrencyLevel(concurrencyLevel.toString());
        }
        if (enableAsyncConflation != null) {
            regionAttributes.setEnableAsyncConflation(enableAsyncConflation);
        }
        if (cloningEnabled != null) {
            regionAttributes.setCloningEnabled(cloningEnabled);
        }
        if (concurrencyChecksEnabled != null) {
            regionAttributes.setConcurrencyChecksEnabled(concurrencyChecksEnabled);
        }
        if (mcastEnabled != null) {
            regionAttributes.setMulticastEnabled(mcastEnabled);
        }
        if (statisticsEnabled != null) {
            regionAttributes.setStatisticsEnabled(statisticsEnabled);
        }
        if (enableSubscriptionConflation != null) {
            regionAttributes.setEnableSubscriptionConflation(enableSubscriptionConflation);
        }
        if (diskSynchronous != null) {
            regionAttributes.setDiskSynchronous(diskSynchronous);
        }
        regionAttributes.updateEntryIdleTime(entryExpirationIdleTime, entryExpirationIdleTimeAction == null ? null : entryExpirationIdleTimeAction.toXmlString(), entryIdleTimeCustomExpiry);
        regionAttributes.updateEntryTimeToLive(entryExpirationTTL, entryExpirationTTLAction == null ? null : entryExpirationTTLAction.toXmlString(), entryTTLCustomExpiry);
        regionAttributes.updateRegionIdleTime(regionExpirationIdleTime, regionExpirationIdleTimeAction == null ? null : regionExpirationIdleTimeAction.toXmlString(), null);
        regionAttributes.updateRegionTimeToLive(regionExpirationTTL, regionExpirationTTLAction == null ? null : regionExpirationTTLAction.toXmlString(), null);
        CreateRegionFunctionArgs functionArgs = new CreateRegionFunctionArgs(regionPath, regionConfig, ifNotExists);
        List<CliFunctionResult> regionCreateResults = this.executeAndGetFunctionResult((Function<?>)RegionCreateFunction.INSTANCE, functionArgs, membersToCreateRegionOn);
        ResultModel resultModel = ResultModel.createMemberStatusResult(regionCreateResults);
        InternalConfigurationPersistenceService service = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (service == null) {
            return resultModel;
        }
        if (resultModel.isSuccessful() && regionCreateResults.stream().anyMatch(res -> res.getStatusMessage() != null && res.getStatusMessage().contains("Skipping"))) {
            return resultModel;
        }
        if (resultModel.isSuccessful()) {
            this.verifyDistributedRegionMbean(cache, regionPath);
            String regionXml = (String)regionCreateResults.stream().filter(CliFunctionResult::isSuccessful).findFirst().get().getResultObject();
            RegionConfig regionConfigFromServer = (RegionConfig)service.getJaxbService().unMarshall(regionXml, RegionConfig.class);
            List extensions = regionConfigFromServer.getCustomRegionElements();
            regionConfig.getCustomRegionElements().addAll(extensions);
            resultModel.setConfigObject(new CreateRegionResult(regionConfig, regionPath));
        }
        return resultModel;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object configObject) {
        if (configObject == null) {
            return false;
        }
        CreateRegionResult regionResultConfigObject = (CreateRegionResult)configObject;
        RegionConfig regionConfig = regionResultConfigObject.getRegionConfig();
        String regionPath = regionResultConfigObject.getFullRegionPath();
        RegionPath regionPathData = new RegionPath(regionPath);
        if (regionPathData.getParent() == null) {
            config.getRegions().add(regionConfig);
            return true;
        }
        String[] regionsOnPath = regionPathData.getRegionsOnParentPath();
        RegionConfig currentConfig = config.getRegions().stream().filter(r1 -> r1.getName().equals(regionsOnPath[0])).findFirst().get();
        for (int i = 1; i < regionsOnPath.length; ++i) {
            String curRegionName = regionsOnPath[i];
            currentConfig = currentConfig.getRegions().stream().filter(r -> r.getName().equals(curRegionName)).findFirst().get();
        }
        currentConfig.getRegions().add(regionConfig);
        return true;
    }

    boolean verifyDistributedRegionMbean(InternalCache cache, String regionName) {
        int federationInterval = cache.getInternalDistributedSystem().getConfig().getJmxManagerUpdateRate();
        long timeEnd = System.currentTimeMillis() + (long)federationInterval + 50L;
        while (System.currentTimeMillis() <= timeEnd) {
            try {
                DistributedRegionMXBean bean = ManagementService.getManagementService((Cache)cache).getDistributedRegionMXBean(regionName);
                if (bean == null) {
                    bean = ManagementService.getManagementService((Cache)cache).getDistributedRegionMXBean("/" + regionName);
                }
                if (bean != null) {
                    return true;
                }
                Thread.sleep(2L);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    RegionConfig findNonProxyRegionsInClusterConfigurationByName(String regionName, InternalConfigurationPersistenceService persistenceService) {
        for (String group : persistenceService.getGroups()) {
            RegionConfig regionConfig;
            CacheConfig config = persistenceService.getCacheConfig(group);
            if (config == null || (regionConfig = (RegionConfig)config.getRegions().stream().filter(region -> region.getName().equals(regionName) && region.getType() != null && !region.getType().contains("PROXY")).findFirst().orElse(null)) == null) continue;
            return regionConfig;
        }
        return null;
    }

    boolean isRegionExistsInGroup(String regionName, String group, InternalConfigurationPersistenceService persistenceService) {
        CacheConfig config = persistenceService.getCacheConfig(group);
        RegionConfig regionConfig = null;
        if (config != null) {
            regionConfig = config.getRegions().stream().filter(region -> region.getName().equals(regionName)).findFirst().orElse(null);
        }
        return regionConfig != null;
    }

    private void failIfRegionExistsInClusterConfiguration(String regionPathFull, String[] groups, RegionShortcut regionShortcut) {
        boolean existingRegionIsNotProxy;
        InternalConfigurationPersistenceService persistenceService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (persistenceService == null) {
            return;
        }
        RegionPath regionPath = new RegionPath(regionPathFull);
        RegionConfig regionConfig = this.findNonProxyRegionsInClusterConfigurationByName(regionPath.getName(), persistenceService);
        if (regionConfig == null) {
            return;
        }
        String existingDataPolicy = regionConfig.getType();
        if (existingDataPolicy == null) {
            return;
        }
        boolean bl = existingRegionIsNotProxy = !existingDataPolicy.contains("PROXY");
        if (regionShortcut.isLocal() || existingDataPolicy.equals("NORMAL") || !regionShortcut.isProxy() && existingRegionIsNotProxy) {
            throw new EntityExistsException(String.format("Region %s already exists on the cluster.", regionPath.getRegionPath()));
        }
        if (regionShortcut.isPartition() && !existingDataPolicy.contains("PARTITION")) {
            LogService.getLogger().info("Create region command: got EntityExists exception");
            throw new EntityExistsException("The existing region is not a partitioned region");
        }
        if (regionShortcut.isReplicate() && !existingDataPolicy.equals("EMPTY") && !existingDataPolicy.contains("REPLICATE") && !existingDataPolicy.contains("PRELOADED")) {
            throw new EntityExistsException("The existing region is not a replicate region");
        }
        if (groups == null) {
            if (this.isRegionExistsInGroup(regionPath.getName(), null, persistenceService)) {
                throw new EntityExistsException(String.format("Region %s already exists on the cluster.", regionPath.getRegionPath()));
            }
        } else {
            ArrayList<String> groupsExists = new ArrayList<String>();
            for (String group : groups) {
                if (!this.isRegionExistsInGroup(regionPath.getName(), group, persistenceService)) continue;
                groupsExists.add(group);
            }
            if (!groupsExists.isEmpty()) {
                throw new EntityExistsException(String.format("Region %s already exists in groups: %s.", regionPath.getRegionPath(), StringUtils.join(groupsExists, (String)",")));
            }
        }
    }

    private void failIfRegionAlreadyExists(String regionPath, RegionShortcut regionShortcut, String[] groups) throws EntityExistsException {
        boolean toBeCreatedIsNotProxy;
        this.failIfRegionExistsInClusterConfiguration(regionPath, groups, regionShortcut);
        DistributedRegionMXBean regionBean = this.getManagementService().getDistributedRegionMXBean(regionPath);
        if (regionBean == null || regionShortcut == null) {
            return;
        }
        String existingDataPolicy = regionBean.getRegionType();
        if (existingDataPolicy == null) {
            return;
        }
        boolean existingRegionIsNotProxy = regionBean.getMemberCount() > regionBean.getEmptyNodes();
        boolean bl = toBeCreatedIsNotProxy = !regionShortcut.isProxy();
        if (regionShortcut.isLocal() || existingDataPolicy.equals("NORMAL") || toBeCreatedIsNotProxy && existingRegionIsNotProxy) {
            throw new EntityExistsException(String.format("Region %s already exists on the cluster.", regionPath));
        }
        if (regionShortcut.isPartition() && !existingDataPolicy.contains("PARTITION")) {
            LogService.getLogger().info("Create region command: got EntityExists exception");
            throw new EntityExistsException("The existing region is not a partitioned region");
        }
        if (regionShortcut.isReplicate() && !existingDataPolicy.equals("EMPTY") && !existingDataPolicy.contains("REPLICATE") && !existingDataPolicy.contains("PRELOADED")) {
            throw new EntityExistsException("The existing region is not a replicate region");
        }
        Set membersWithThisRegion = Arrays.stream(regionBean.getMembers()).collect(Collectors.toSet());
        Set membersWithinGroup = this.findMembers(groups, null).stream().map(DistributedMember::getName).collect(Collectors.toSet());
        if (!Collections.disjoint(membersWithinGroup, membersWithThisRegion)) {
            throw new EntityExistsException(String.format("Region %s already exists on these members: %s.", regionPath, StringUtils.join(membersWithThisRegion, (String)",")));
        }
    }

    boolean regionExists(String regionPath) {
        if (regionPath == null || "/".equals(regionPath)) {
            return false;
        }
        Object managementService = this.getManagementService();
        DistributedSystemMXBean dsMBean = managementService.getDistributedSystemMXBean();
        String[] allRegionPaths = dsMBean.listAllRegionPaths();
        return Arrays.asList(allRegionPaths).contains(regionPath);
    }

    private boolean diskStoreExists(String diskStoreName) {
        Object managementService = this.getManagementService();
        DistributedSystemMXBean dsMXBean = managementService.getDistributedSystemMXBean();
        return Arrays.stream(dsMXBean.listMembers()).anyMatch(member -> DiskStoreCommandsUtils.diskStoreBeanAndMemberBeanDiskStoreExists(dsMXBean, member, diskStoreName));
    }

    DistributedSystemMXBean getDSMBean() {
        Object managementService = this.getManagementService();
        return managementService.getDistributedSystemMXBean();
    }

    private static /* synthetic */ boolean lambda$createRegion$1(String normalizedTemplateRegion, RegionConfig c) {
        return c.getName().equals(normalizedTemplateRegion.substring(1));
    }

    private class CreateRegionResult {
        private final RegionConfig regionConfig;
        private final String fullRegionPath;

        RegionConfig getRegionConfig() {
            return this.regionConfig;
        }

        String getFullRegionPath() {
            return this.fullRegionPath;
        }

        CreateRegionResult(RegionConfig regionConfig, String fullRegionPath) {
            this.regionConfig = regionConfig;
            this.fullRegionPath = fullRegionPath;
        }
    }
}

