/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.GatewayReceiverConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.functions.GatewayReceiverCreateFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class CreateGatewayReceiverCommand
extends SingleGfshCommand {
    @ShellMethod(value="Create the Gateway Receiver on a member or members.", key={"create gateway-receiver"})
    @CliMetaData(relatedTopic={"WAN"}, interceptor="org.apache.geode.management.internal.cli.commands.CreateGatewayReceiverCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public ResultModel createGatewayReceiver(@ShellOption(value={"group", "groups"}, help="Group(s) of members on which to create the Gateway Receiver.") String[] onGroups, @ShellOption(value={"member", "members"}, help="Name/Id of the member on which to create the Gateway Receiver.") String[] onMember, @ShellOption(value={"manual-start"}, help="Whether manual start is to be enabled or the receiver will start automatically after creation.", defaultValue="false") Boolean manualStart, @ShellOption(value={"start-port"}, help="Starting value of the port range from which the GatewayReceiver's port will be chosen.") Integer startPort, @ShellOption(value={"end-port"}, help="End value of the port range from which the GatewayReceiver's port will be chosen.") Integer endPort, @ShellOption(value={"bind-address"}, help="The IP address or host name that the receiver's socket will listen on for client connections.") String bindAddress, @ShellOption(value={"maximum-time-between-pings"}, help="The maximum amount of time between client pings.") Integer maximumTimeBetweenPings, @ShellOption(value={"socket-buffer-size"}, help="The buffer size in bytes of the socket connection for this GatewayReceiver.") Integer socketBufferSize, @ShellOption(value={"gateway-transport-filter"}, help="The fully qualified class names of GatewayTransportFilters (separated by comma) to be added to the GatewayReceiver. e.g. gateway-transport-filter=com.user.filters.MyFilter1,com.user.filters.MyFilters2") String[] gatewayTransportFilters, @ShellOption(value={"hostname-for-senders"}, help="The host name that server locators will tell GatewaySenders this GatewayReceiver is listening on.") String hostnameForSenders, @ShellOption(value={"if-not-exists"}, help="If true, the command will be a no-op if the entity does exist.", defaultValue="false") Boolean ifNotExists) {
        GatewayReceiverConfig configuration = this.buildConfiguration(manualStart, startPort, endPort, bindAddress, maximumTimeBetweenPings, socketBufferSize, gatewayTransportFilters, hostnameForSenders);
        Set<DistributedMember> membersToCreateGatewayReceiverOn = this.getMembers(onGroups, onMember);
        List<CliFunctionResult> gatewayReceiverCreateResults = this.executeAndGetFunctionResult((Function<?>)GatewayReceiverCreateFunction.INSTANCE, new Object[]{configuration, ifNotExists}, membersToCreateGatewayReceiverOn);
        ResultModel result = ResultModel.createMemberStatusResult(gatewayReceiverCreateResults);
        result.setConfigObject(configuration);
        return result;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object configObject) {
        config.setGatewayReceiver((GatewayReceiverConfig)configObject);
        return true;
    }

    private GatewayReceiverConfig buildConfiguration(Boolean manualStart, Integer startPort, Integer endPort, String bindAddress, Integer maximumTimeBetweenPings, Integer socketBufferSize, String[] gatewayTransportFilters, String hostnameForSenders) {
        GatewayReceiverConfig configuration = new GatewayReceiverConfig();
        if (gatewayTransportFilters != null) {
            List filters = Arrays.stream(gatewayTransportFilters).map(fullyQualifiedClassName -> {
                DeclarableType thisFilter = new DeclarableType();
                thisFilter.setClassName(fullyQualifiedClassName);
                return thisFilter;
            }).collect(Collectors.toList());
            configuration.getGatewayTransportFilters().addAll(filters);
        }
        if (startPort != null) {
            configuration.setStartPort(String.valueOf(startPort));
        }
        if (endPort != null) {
            configuration.setEndPort(String.valueOf(endPort));
        }
        configuration.setBindAddress(bindAddress);
        if (maximumTimeBetweenPings != null) {
            configuration.setMaximumTimeBetweenPings(String.valueOf(maximumTimeBetweenPings));
        }
        if (socketBufferSize != null) {
            configuration.setSocketBufferSize(String.valueOf(socketBufferSize));
        }
        configuration.setHostnameForSenders(hostnameForSenders);
        configuration.setManualStart(manualStart);
        return configuration;
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            Integer startPort = (Integer)parseResult.getParamValue("start-port");
            Integer endPort = (Integer)parseResult.getParamValue("end-port");
            if (startPort == null) {
                startPort = 5000;
            }
            if (endPort == null) {
                endPort = 5500;
            }
            if (startPort > endPort) {
                return ResultModel.createError("start-port must be smaller than end-port.");
            }
            return ResultModel.createInfo("");
        }
    }
}

