/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.DiskDirType;
import org.apache.geode.cache.configuration.DiskStoreType;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.domain.DiskStoreDetails;
import org.apache.geode.management.internal.cli.functions.CreateDiskStoreFunction;
import org.apache.geode.management.internal.cli.functions.ListDiskStoresFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class CreateDiskStoreCommand
extends SingleGfshCommand {
    private static final int MBEAN_CREATION_WAIT_TIME = 10000;

    @ShellMethod(value="Create a disk store.", key={"create disk-store"})
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DISK)
    public ResultModel createDiskStore(@ShellOption(value={"dir"}, help="Directories where the disk store files will be written, the directories will be created if they don't exist.  Optionally, directory names may be followed by # and the maximum number of megabytes that the disk store can use in the directory.  Example: --dir=/data/ds1 --dir=/data/ds2#5000") String[] directoriesAndSizes, @ShellOption(value={"name"}, help="Name of the disk store to be created.") String name, @ShellOption(value={"allow-force-compaction"}, defaultValue="false", help="Whether to allow manual compaction through the API or command-line tools.") boolean allowForceCompaction, @ShellOption(value={"auto-compact"}, defaultValue="true", help="Whether to automatically compact a file when it reaches the compaction-threshold.") boolean autoCompact, @ShellOption(value={"compaction-threshold"}, defaultValue="50", help="Percentage of garbage allowed in the file before it is eligible for compaction.") int compactionThreshold, @ShellOption(value={"max-oplog-size"}, defaultValue="1024", help="The largest size, in megabytes, to allow an operation log to become before automatically rolling to a new file.") int maxOplogSize, @ShellOption(value={"queue-size"}, defaultValue="0", help="For asynchronous queueing. The maximum number of operations to allow into the write queue before automatically flushing the queue. The default of 0 indicates no limit.") int queueSize, @ShellOption(value={"time-interval"}, defaultValue="1000", help="For asynchronous queueing. The number of milliseconds that can elapse before data is flushed to disk. Reaching this limit or the queue-size limit causes the queue to flush.") long timeInterval, @ShellOption(value={"write-buffer-size"}, defaultValue="32768", help="Size in bytes of the buffer used to write to disk.") int writeBufferSize, @ShellOption(value={"group", "groups"}, help="Group(s) of members on which the disk store will be created. If no group is specified the disk store will be created on all members.") String[] groups, @ShellOption(value={"disk-usage-warning-percentage"}, defaultValue="90", help="Warning percentage for disk volume usage.") float diskUsageWarningPercentage, @ShellOption(value={"disk-usage-critical-percentage"}, defaultValue="99", help="Critical percentage for disk volume usage.") float diskUsageCriticalPercentage) {
        DiskStoreAttributes diskStoreAttributes = new DiskStoreAttributes();
        diskStoreAttributes.allowForceCompaction = allowForceCompaction;
        diskStoreAttributes.autoCompact = autoCompact;
        diskStoreAttributes.compactionThreshold = compactionThreshold;
        diskStoreAttributes.maxOplogSizeInBytes = (long)maxOplogSize * 0x100000L;
        diskStoreAttributes.queueSize = queueSize;
        diskStoreAttributes.timeInterval = timeInterval;
        diskStoreAttributes.writeBufferSize = writeBufferSize;
        diskStoreAttributes.name = name;
        File[] directories = new File[directoriesAndSizes.length];
        int[] sizes = new int[directoriesAndSizes.length];
        for (int i = 0; i < directoriesAndSizes.length; ++i) {
            int hashPosition = directoriesAndSizes[i].indexOf(35);
            if (hashPosition == -1) {
                directories[i] = new File(directoriesAndSizes[i]);
                sizes[i] = Integer.MAX_VALUE;
                continue;
            }
            directories[i] = new File(directoriesAndSizes[i].substring(0, hashPosition));
            String dirSizeString = directoriesAndSizes[i].substring(hashPosition + 1);
            this.verifyDirSizeConstraints(dirSizeString);
            sizes[i] = Integer.parseInt(dirSizeString);
        }
        diskStoreAttributes.diskDirs = directories;
        diskStoreAttributes.diskDirSizes = sizes;
        diskStoreAttributes.setDiskUsageWarningPercentage(diskUsageWarningPercentage);
        diskStoreAttributes.setDiskUsageCriticalPercentage(diskUsageCriticalPercentage);
        Set<DistributedMember> targetMembers = this.findMembers(groups, null);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        Pair<Boolean, String> validationResult = this.validateDiskstoreAttributes(diskStoreAttributes, targetMembers);
        if (((Boolean)validationResult.getLeft()).equals(Boolean.FALSE)) {
            return ResultModel.createError((String)validationResult.getRight());
        }
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult((Function<?>)new CreateDiskStoreFunction(), new Object[]{name, diskStoreAttributes}, targetMembers);
        ResultModel result = ResultModel.createMemberStatusResult(functionResults);
        result.setConfigObject(this.createDiskStoreType(name, diskStoreAttributes));
        if (!this.waitForDiskStoreMBeanCreation(name, targetMembers)) {
            result.addInfo().addLine("Did not complete waiting for Disk Store MBean proxy creation");
        }
        return result;
    }

    @VisibleForTesting
    void verifyDirSizeConstraints(String dirSize) {
        long dirSizeLongValue;
        try {
            dirSizeLongValue = Long.parseLong(dirSize);
        }
        catch (NumberFormatException exc) {
            throw new IllegalArgumentException(String.format("Incorrect directory size specified (%s)", dirSize));
        }
        if (dirSizeLongValue > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Directory size (%s) is over the maximum allowed value.", dirSize));
        }
        if (dirSizeLongValue < 0L) {
            throw new IllegalArgumentException(String.format("Directory size cannot be negative (%s)", dirSize));
        }
    }

    @VisibleForTesting
    boolean waitForDiskStoreMBeanCreation(String diskStore, Set<DistributedMember> membersToCreateDiskStoreOn) {
        DistributedSystemMXBean dsMXBean = this.getManagementService().getDistributedSystemMXBean();
        return this.poll(10000L, TimeUnit.MILLISECONDS, () -> membersToCreateDiskStoreOn.stream().allMatch(m -> DiskStoreCommandsUtils.diskStoreBeanAndMemberBeanDiskStoreExists(dsMXBean, m.getName(), diskStore)));
    }

    @VisibleForTesting
    Pair<Boolean, String> validateDiskstoreAttributes(DiskStoreAttributes diskStoreAttributes, Set<DistributedMember> targetMembers) {
        List<DiskStoreDetails> currentDiskstores = this.getDiskStoreListing(targetMembers);
        for (DiskStoreDetails detail : currentDiskstores) {
            if (!detail.getName().equals(diskStoreAttributes.getName())) continue;
            return Pair.of((Object)Boolean.FALSE, (Object)String.format("Error: Disk store %s already exists", diskStoreAttributes.getName()));
        }
        return Pair.of((Object)Boolean.TRUE, null);
    }

    private DiskStoreType createDiskStoreType(String name, DiskStoreAttributes diskStoreAttributes) {
        DiskStoreType diskStoreType = new DiskStoreType();
        diskStoreType.setAllowForceCompaction(Boolean.valueOf(diskStoreAttributes.getAllowForceCompaction()));
        diskStoreType.setAutoCompact(Boolean.valueOf(diskStoreAttributes.getAutoCompact()));
        diskStoreType.setCompactionThreshold(Integer.toString(diskStoreAttributes.getCompactionThreshold()));
        ArrayList<DiskDirType> diskDirs = new ArrayList<DiskDirType>();
        for (int i = 0; i < diskStoreAttributes.getDiskDirs().length; ++i) {
            DiskDirType diskDir = new DiskDirType();
            File diskDirFile = diskStoreAttributes.getDiskDirs()[i];
            diskDir.setContent(diskDirFile.toString());
            diskDir.setDirSize(Integer.toString(diskStoreAttributes.getDiskDirSizes()[i]));
            diskDirs.add(diskDir);
        }
        diskStoreType.setDiskDirs(diskDirs);
        diskStoreType.setDiskUsageCriticalPercentage(Integer.toString((int)diskStoreAttributes.getDiskUsageCriticalPercentage()));
        diskStoreType.setDiskUsageWarningPercentage(Integer.toString((int)diskStoreAttributes.getDiskUsageWarningPercentage()));
        diskStoreType.setMaxOplogSize(Integer.toString((int)diskStoreAttributes.getMaxOplogSize()));
        diskStoreType.setName(diskStoreAttributes.getName());
        diskStoreType.setQueueSize(Integer.toString(diskStoreAttributes.getQueueSize()));
        diskStoreType.setTimeInterval(Integer.toString((int)diskStoreAttributes.getTimeInterval()));
        diskStoreType.setWriteBufferSize(Integer.toString(diskStoreAttributes.getWriteBufferSize()));
        return diskStoreType;
    }

    private List<DiskStoreDetails> getDiskStoreListing(Set<DistributedMember> members) {
        Execution membersFunctionExecutor = this.getMembersFunctionExecutor(members);
        if (membersFunctionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)membersFunctionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector resultCollector = membersFunctionExecutor.execute((Function)new ListDiskStoresFunction());
        List results = (List)resultCollector.getResult();
        ArrayList<DiskStoreDetails> distributedSystemMemberDiskStores = new ArrayList<DiskStoreDetails>(results.size());
        for (Object result : results) {
            if (!(result instanceof Set)) continue;
            distributedSystemMemberDiskStores.addAll((Set)result);
        }
        Collections.sort(distributedSystemMemberDiskStores);
        return distributedSystemMemberDiskStores;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object configObject) {
        DiskStoreType diskStoreType = (DiskStoreType)configObject;
        config.getDiskStores().add(diskStoreType);
        return true;
    }
}

