/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.commands.IndexDefinition;
import org.apache.geode.management.internal.cli.functions.CreateDefinedIndexesFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class CreateDefinedIndexesCommand
extends SingleGfshCommand {
    public static final String CREATE_DEFINED_INDEXES_SECTION = "create-defined-indexes";
    @Immutable
    private static final CreateDefinedIndexesFunction createDefinedIndexesFunction = new CreateDefinedIndexesFunction();

    @ShellMethod(value="Creates all the defined indexes.", key={"create defined indexes"})
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public ResultModel createDefinedIndexes(@ShellOption(value={"member", "members"}, help="Name/Id of the member in which the index will be created.") String[] memberNameOrID, @ShellOption(value={"group", "groups"}, help="Group of members in which the index will be created. Value will be ignored when using cluster configuration.") String[] groups) {
        ResultModel result = new ResultModel();
        if (IndexDefinition.indexDefinitions.isEmpty()) {
            return ResultModel.createInfo("No indexes defined");
        }
        Set<DistributedMember> targetMembers = this.findMembers(groups, memberNameOrID);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult((Function<?>)createDefinedIndexesFunction, IndexDefinition.indexDefinitions, targetMembers);
        result.addTableAndSetStatus(CREATE_DEFINED_INDEXES_SECTION, functionResults, false, true);
        result.setConfigObject(IndexDefinition.indexDefinitions);
        return result;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object configObject) {
        Set updatedIndexes = (Set)configObject;
        if (updatedIndexes == null) {
            return false;
        }
        for (RegionConfig.Index index : updatedIndexes) {
            RegionConfig regionConfig = this.getValidRegionConfig(index.getFromClause(), config);
            if (regionConfig == null) {
                throw new IllegalStateException("RegionConfig is null");
            }
            regionConfig.getIndexes().add(index);
        }
        return true;
    }

    RegionConfig getValidRegionConfig(String regionPath, CacheConfig cacheConfig) {
        String[] regionPathTokens = regionPath.trim().split(" ");
        regionPath = regionPathTokens[0];
        RegionConfig regionConfig = cacheConfig.findRegionConfiguration(regionPath);
        while (regionPath.contains(".") && regionConfig == null) {
            regionPath = regionPath.substring(0, regionPath.lastIndexOf("."));
            regionConfig = cacheConfig.findRegionConfiguration(regionPath);
        }
        return regionConfig;
    }
}

