/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.functions.CreateAsyncEventQueueFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class CreateAsyncEventQueueCommand
extends SingleGfshCommand {
    @ShellMethod(value="Create Async Event Queue.", key={"create async-event-queue"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DEPLOY)
    public ResultModel createAsyncEventQueue(@ShellOption(value={"id"}, help="ID of the queue to be created.") String id, @ShellOption(value={"group", "groups"}, help="Group(s) of members on which queue will be created. If no group is specified the queue will be created on all members.") String[] groups, @ShellOption(value={"parallel"}, defaultValue="false", help="Whether this queue is parallel.") boolean parallel, @ShellOption(value={"enable-batch-conflation"}, defaultValue="false", help="Whether to enable batch conflation.") boolean enableBatchConflation, @ShellOption(value={"batch-size"}, defaultValue="100", help="Maximum number of events that a batch can contain.") int batchSize, @ShellOption(value={"batch-time-interval"}, defaultValue="5", help="Maximum amount of time, in ms, that can elapse before a batch is delivered.") int batchTimeInterval, @ShellOption(value={"persistent"}, defaultValue="false", help="Whether events should be persisted to a disk store.") boolean persistent, @ShellOption(value={"disk-store"}, help="Disk store to be used by this queue.") String diskStore, @ShellOption(value={"disk-synchronous"}, defaultValue="true", help="Whether disk writes are synchronous.") boolean diskSynchronous, @ShellOption(value={"forward-expiration-destroy"}, defaultValue="false", help="Whether to forward expiration destroy events.") boolean forwardExpirationDestroy, @ShellOption(value={"max-queue-memory"}, defaultValue="100", help="Maximum amount of memory, in megabytes, that the queue can consume before overflowing to disk.") int maxQueueMemory, @ShellOption(value={"dispatcher-threads"}, defaultValue="1", help="Number of threads to use for sending events.") int dispatcherThreads, @ShellOption(value={"order-policy"}, defaultValue="KEY", help="Policy for dispatching events when --dispatcher-threads is > 1. Possible values are 'THREAD', 'KEY', 'PARTITION'.") String orderPolicy, @ShellOption(value={"gateway-event-filter"}, help="List of fully qualified class names of GatewayEventFilters for this queue.  These classes filter events before dispatching to remote servers.") String[] gatewayEventFilters, @ShellOption(value={"gateway-event-substitution-filter"}, help="Fully qualified class name of the GatewayEventSubstitutionFilter for this queue.") String gatewaySubstitutionListener, @ShellOption(value={"listener"}, help="Fully qualified class name of the AsyncEventListener for this queue.") String listener, @ShellOption(value={"listener-param"}, help="Parameter name for the AsyncEventListener.  Optionally, parameter names may be followed by # and a value for the parameter.  Example: --listener-param=loadAll --listener-param=maxRead#1024") String[] listenerParamsAndValues, @ShellOption(value={"pause-event-processing"}, help="AsyncEventQueue will be created with a paused event processor. resume command must be executed to resume event processing.", defaultValue="false") boolean pauseEventProcessing) {
        if (persistent) {
            this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.WRITE, ResourcePermission.Target.DISK);
        }
        Properties listenerProperties = new Properties();
        if (listenerParamsAndValues != null) {
            for (String listenerParamsAndValue : listenerParamsAndValues) {
                int hashPosition = listenerParamsAndValue.indexOf(35);
                if (hashPosition == -1) {
                    listenerProperties.put(listenerParamsAndValue, "");
                    continue;
                }
                listenerProperties.put(listenerParamsAndValue.substring(0, hashPosition), listenerParamsAndValue.substring(hashPosition + 1));
            }
        }
        Set<DistributedMember> targetMembers = this.getMembers(groups, null);
        CacheConfig.AsyncEventQueue config = new CacheConfig.AsyncEventQueue();
        config.setAsyncEventListener(new DeclarableType(listener, listenerProperties));
        config.setBatchSize(String.valueOf(batchSize));
        config.setBatchTimeInterval(String.valueOf(batchTimeInterval));
        config.setDiskStoreName(diskStore);
        config.setDiskSynchronous(Boolean.valueOf(diskSynchronous));
        config.setDispatcherThreads(String.valueOf(dispatcherThreads));
        config.setEnableBatchConflation(Boolean.valueOf(enableBatchConflation));
        config.setForwardExpirationDestroy(Boolean.valueOf(forwardExpirationDestroy));
        if (gatewayEventFilters != null) {
            config.getGatewayEventFilters().addAll(Arrays.stream(gatewayEventFilters).map(DeclarableType::new).collect(Collectors.toList()));
        }
        if (gatewaySubstitutionListener != null) {
            config.setGatewayEventSubstitutionFilter(new DeclarableType(gatewaySubstitutionListener));
        }
        config.setId(id);
        config.setMaximumQueueMemory(String.valueOf(maxQueueMemory));
        config.setOrderPolicy(orderPolicy);
        config.setParallel(Boolean.valueOf(parallel));
        config.setPersistent(Boolean.valueOf(persistent));
        config.setPauseEventProcessing(Boolean.valueOf(pauseEventProcessing));
        CreateAsyncEventQueueFunction function = new CreateAsyncEventQueueFunction();
        List<CliFunctionResult> results = this.executeAndGetFunctionResult((Function<?>)function, config, targetMembers);
        ResultModel commandResult = ResultModel.createMemberStatusResult(results);
        commandResult.setConfigObject(config);
        return commandResult;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object configObject) {
        config.getAsyncEventQueues().add((CacheConfig.AsyncEventQueue)configObject);
        return true;
    }
}

