/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CloseDurableCqFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class CloseDurableCQsCommand
extends GfshCommand {
    @ShellMethod(value="Closes the durable cq registered by the durable client and drains events held for the durable cq from the subscription queue.", key={"close durable-cq"})
    @CliMetaData
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public ResultModel closeDurableCqs(@ShellOption(value={"durable-client-id"}, help="The id of the durable client") String durableClientId, @ShellOption(value={"durable-cq-name"}, help="Name of the cq to be closed.") String cqName, @ShellOption(value={"member", "members"}, help="Name/Id of the member for which the durable client is registered and the cq to be closed.") String[] memberNameOrId, @ShellOption(value={"group", "groups"}, help="Group of members for which the durable client is registered and the cq to be closed.") String[] group) {
        Set<DistributedMember> targetMembers = this.findMembers(group, memberNameOrId);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        String[] params = new String[]{durableClientId, cqName};
        ResultCollector<?, ?> rc = this.executeFunction((Function<?>)new CloseDurableCqFunction(), (Object)params, targetMembers);
        List results = (List)rc.getResult();
        return ResultModel.createMemberStatusResult(results);
    }
}

