/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.configuration.ClassName;
import org.apache.geode.management.internal.cli.functions.RegionAlterFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class AlterRegionCommand
extends SingleGfshCommand {
    @ShellMethod(value="Alter a region with the given path and configuration.", key={"alter region"})
    @CliMetaData(relatedTopic={"Region"})
    public ResultModel alterRegion(@ShellOption(value={"name"}, help="Name/Path of the region to be altered.") String regionPath, @ShellOption(value={"group", "groups"}, help="Group(s) of members on which the region will be altered.") String[] groups, @ShellOption(value={"entry-idle-time-expiration"}, help="How long the region's entries can remain in the cache without being accessed. The default is no expiration of this type.") Integer entryExpirationIdleTime, @ShellOption(value={"entry-idle-time-expiration-action"}, help="Action to be taken on an entry that has exceeded the idle expiration.") ExpirationAction entryExpirationIdleTimeAction, @ShellOption(value={"entry-time-to-live-expiration"}, help="How long the region's entries can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer entryExpirationTTL, @ShellOption(value={"entry-time-to-live-expiration-action"}, help="Action to be taken on an entry that has exceeded the TTL expiration.") ExpirationAction entryExpirationTTLAction, @ShellOption(value={"entry-idle-time-custom-expiry"}, help="The name of the class implementing CustomExpiry for entry idle time. Append json string for initialization properties.") ClassName entryIdleTimeCustomExpiry, @ShellOption(value={"entry-time-to-live-custom-expiry"}, help="The name of the class implementing CustomExpiry for entry time to live. Append json string for initialization properties.") ClassName entryTTLCustomExpiry, @ShellOption(value={"region-idle-time-expiration"}, help="How long the region can remain in the cache without being accessed. The default is no expiration of this type.") Integer regionExpirationIdleTime, @ShellOption(value={"region-idle-time-expiration-action"}, help="Action to be taken on a region that has exceeded the idle expiration.") ExpirationAction regionExpirationIdleTimeAction, @ShellOption(value={"region-time-to-live-expiration"}, help="How long the region can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer regionExpirationTTL, @ShellOption(value={"region-time-to-live-expiration-action"}, help="Action to be taken on a region that has exceeded the TTL expiration.") ExpirationAction regionExpirationTTLAction, @ShellOption(value={"cache-listener"}, help="Fully qualified class name of a plug-in to be instantiated for receiving after-event notification of changes to the region and its entries. Any number of cache listeners can be configured.") ClassName[] cacheListeners, @ShellOption(value={"cache-loader"}, help="Fully qualified class name of a plug-in to be instantiated for receiving notification of cache misses in the region. At most, one cache loader can be defined in each member for the region. For distributed regions, a cache loader may be invoked remotely from other members that have the region defined.") ClassName cacheLoader, @ShellOption(value={"cache-writer"}, help="Fully qualified class name of a plug-in to be instantiated for receiving before-event notification of changes to the region and its entries. The plug-in may cancel the event. At most, one cache writer can be defined in each member for the region.") ClassName cacheWriter, @ShellOption(value={"async-event-queue-id"}, help="IDs of the Async Event Queues that will be used for write-behind operations.") String[] asyncEventQueueIds, @ShellOption(value={"gateway-sender-id"}, help="IDs of the Gateway Senders to which data will be routed.") String[] gatewaySenderIds, @ShellOption(value={"enable-cloning"}, help="Determines how fromDelta applies deltas to the local cache for delta propagation. When true, the updates are applied to a clone of the value and then the clone is saved to the cache. When false, the value is modified in place in the cache.") Boolean cloningEnabled, @ShellOption(value={"eviction-max"}, help="Maximum value for the Eviction Attributes which the Eviction Algorithm uses to determine when to perform its Eviction Action. The unit of the maximum value is determined by the Eviction Algorithm.") Integer evictionMax) {
        this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.MANAGE, regionPath);
        Set<DistributedMember> targetMembers = this.findMembers(groups, null);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        Object ccService = this.getConfigurationPersistenceService();
        if (groups == null) {
            groups = new String[]{"cluster"};
        }
        if (ccService != null) {
            for (String group : groups) {
                CacheConfig clusterConfig = ccService.getCacheConfig(group);
                RegionConfig regionConfig = null;
                if (clusterConfig != null) {
                    regionConfig = (RegionConfig)Identifiable.find((List)clusterConfig.getRegions(), (String)regionPath.substring(1));
                }
                if (regionConfig != null) continue;
                throw new EntityNotFoundException(String.format("%s does not exist in group %s", regionPath, group));
            }
        }
        RegionConfig deltaConfig = new RegionConfig();
        deltaConfig.setName(regionPath);
        RegionAttributesType regionAttributesType = new RegionAttributesType();
        deltaConfig.setRegionAttributes(regionAttributesType);
        regionAttributesType.setEntryIdleTime(RegionAttributesType.ExpirationAttributesType.generate((Integer)entryExpirationIdleTime, (String)(entryExpirationIdleTimeAction == null ? null : entryExpirationIdleTimeAction.toXmlString()), (ClassName)entryIdleTimeCustomExpiry));
        regionAttributesType.setEntryTimeToLive(RegionAttributesType.ExpirationAttributesType.generate((Integer)entryExpirationTTL, (String)(entryExpirationTTLAction == null ? null : entryExpirationTTLAction.toXmlString()), (ClassName)entryTTLCustomExpiry));
        regionAttributesType.setRegionIdleTime(RegionAttributesType.ExpirationAttributesType.generate((Integer)regionExpirationIdleTime, (String)(regionExpirationIdleTimeAction == null ? null : regionExpirationIdleTimeAction.toXmlString()), null));
        regionAttributesType.setRegionTimeToLive(RegionAttributesType.ExpirationAttributesType.generate((Integer)regionExpirationTTL, (String)(regionExpirationTTLAction == null ? null : regionExpirationTTLAction.toXmlString()), null));
        if (cacheLoader != null) {
            if (cacheLoader.equals((Object)ClassName.EMPTY)) {
                regionAttributesType.setCacheLoader(DeclarableType.EMPTY);
            } else {
                regionAttributesType.setCacheLoader(new DeclarableType(cacheLoader.getClassName(), cacheLoader.getInitProperties()));
            }
        }
        if (cacheWriter != null) {
            if (cacheWriter.equals((Object)ClassName.EMPTY)) {
                regionAttributesType.setCacheWriter(DeclarableType.EMPTY);
            } else {
                regionAttributesType.setCacheWriter(new DeclarableType(cacheWriter.getClassName(), cacheWriter.getInitProperties()));
            }
        }
        if (cacheListeners != null) {
            regionAttributesType.getCacheListeners().addAll(Arrays.stream(cacheListeners).map(l -> l.equals((Object)ClassName.EMPTY) ? DeclarableType.EMPTY : new DeclarableType(l.getClassName(), l.getInitProperties())).collect(Collectors.toList()));
        }
        if (gatewaySenderIds != null) {
            regionAttributesType.setGatewaySenderIds(StringUtils.join((Object[])gatewaySenderIds, (String)","));
        }
        if (asyncEventQueueIds != null) {
            regionAttributesType.setAsyncEventQueueIds(StringUtils.join((Object[])asyncEventQueueIds, (String)","));
        }
        if (cloningEnabled != null) {
            regionAttributesType.setCloningEnabled(cloningEnabled);
        }
        if (evictionMax != null && evictionMax < 0) {
            throw new IllegalArgumentException(CliStrings.format((String)"Specify 0 or a positive integer value for eviction-max.  \"{0}\" is not valid.", (Object)evictionMax));
        }
        if (evictionMax != null) {
            RegionAttributesType.EvictionAttributes evictionAttributes = new RegionAttributesType.EvictionAttributes();
            RegionAttributesType.EvictionAttributes.LruEntryCount lruEntryCount = new RegionAttributesType.EvictionAttributes.LruEntryCount();
            lruEntryCount.setMaximum(evictionMax.toString());
            evictionAttributes.setLruEntryCount(lruEntryCount);
            regionAttributesType.setEvictionAttributes(evictionAttributes);
        }
        List<CliFunctionResult> regionAlterResults = this.executeAndGetFunctionResult((Function<?>)new RegionAlterFunction(), deltaConfig, targetMembers);
        ResultModel result = ResultModel.createMemberStatusResult(regionAlterResults);
        result.setConfigObject(deltaConfig);
        return result;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig cacheConfig, Object configObject) {
        RegionAttributesType.EvictionAttributes evictionAttributes;
        RegionConfig deltaConfig = (RegionConfig)configObject;
        RegionConfig existingConfig = (RegionConfig)Identifiable.find((List)cacheConfig.getRegions(), (String)deltaConfig.getId());
        RegionAttributesType deltaAttributes = deltaConfig.getRegionAttributes();
        RegionAttributesType existingAttributes = existingConfig.getRegionAttributes();
        existingAttributes.setEntryIdleTime(RegionAttributesType.ExpirationAttributesType.combine((RegionAttributesType.ExpirationAttributesType)existingAttributes.getEntryIdleTime(), (RegionAttributesType.ExpirationAttributesType)deltaAttributes.getEntryIdleTime()));
        existingAttributes.setEntryTimeToLive(RegionAttributesType.ExpirationAttributesType.combine((RegionAttributesType.ExpirationAttributesType)existingAttributes.getEntryTimeToLive(), (RegionAttributesType.ExpirationAttributesType)deltaAttributes.getEntryTimeToLive()));
        existingAttributes.setRegionIdleTime(RegionAttributesType.ExpirationAttributesType.combine((RegionAttributesType.ExpirationAttributesType)existingAttributes.getRegionIdleTime(), (RegionAttributesType.ExpirationAttributesType)deltaAttributes.getRegionIdleTime()));
        existingAttributes.setRegionTimeToLive(RegionAttributesType.ExpirationAttributesType.combine((RegionAttributesType.ExpirationAttributesType)existingAttributes.getRegionTimeToLive(), (RegionAttributesType.ExpirationAttributesType)deltaAttributes.getRegionTimeToLive()));
        if (deltaAttributes.getCacheLoader() != null) {
            if (deltaAttributes.getCacheLoader().equals((Object)DeclarableType.EMPTY)) {
                existingAttributes.setCacheLoader(null);
            } else {
                existingAttributes.setCacheLoader(deltaAttributes.getCacheLoader());
            }
        }
        if (deltaAttributes.getCacheWriter() != null) {
            if (deltaAttributes.getCacheWriter().equals((Object)DeclarableType.EMPTY)) {
                existingAttributes.setCacheWriter(null);
            } else {
                existingAttributes.setCacheWriter(deltaAttributes.getCacheWriter());
            }
        }
        if (!deltaAttributes.getCacheListeners().isEmpty()) {
            existingAttributes.getCacheListeners().clear();
            if (!((DeclarableType)deltaAttributes.getCacheListeners().get(0)).equals((Object)DeclarableType.EMPTY)) {
                existingAttributes.getCacheListeners().addAll(deltaAttributes.getCacheListeners());
            }
        }
        if (deltaAttributes.getGatewaySenderIds() != null) {
            existingAttributes.setGatewaySenderIds(deltaAttributes.getGatewaySenderIds());
        }
        if (deltaAttributes.getAsyncEventQueueIds() != null) {
            existingAttributes.setAsyncEventQueueIds(deltaAttributes.getAsyncEventQueueIds());
        }
        if (deltaAttributes.isCloningEnabled() != null) {
            existingAttributes.setCloningEnabled(deltaAttributes.isCloningEnabled());
        }
        if ((evictionAttributes = deltaAttributes.getEvictionAttributes()) != null) {
            String newMax = evictionAttributes.getLruEntryCount().getMaximum();
            RegionAttributesType.EvictionAttributes existingEviction = existingAttributes.getEvictionAttributes();
            if (existingEviction != null) {
                if (existingEviction.getLruEntryCount() != null) {
                    existingEviction.getLruEntryCount().setMaximum(newMax);
                }
                if (existingEviction.getLruMemorySize() != null) {
                    existingEviction.getLruMemorySize().setMaximum(newMax);
                }
            }
        }
        return true;
    }
}

