/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import org.apache.geode.cache.CacheExistsException;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class AlterOfflineDiskStoreCommand
extends GfshCommand {
    @ShellMethod(value="Alter some options for a region or remove a region in an offline disk store.", key={"alter disk-store"})
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public ResultModel alterOfflineDiskStore(@ShellOption(value={"name"}, help="Name of the disk store whose contents will be altered.") String diskStoreName, @ShellOption(value={"region"}, help="Name/Path of the region in the disk store to alter.") String regionName, @ShellOption(value={"disk-dirs"}, help="Directories where data for the disk store was previously written.") String[] diskDirs, @ShellOption(value={"compressor"}, help="The fully-qualified class name of the Compressor to use when compressing region entry values. A value of 'none' will remove the Compressor.") String compressorClassName, @ShellOption(value={"concurrency-level"}, help="An estimate of the maximum number of application threads that will concurrently modify a region at one time. This attribute does not apply to partitioned regions.") Integer concurrencyLevel, @ShellOption(value={"enable-statistics"}, help="Whether to enable statistics. Valid values are: true and false.") Boolean statisticsEnabled, @ShellOption(value={"initial-capacity"}, help="Together with --load-factor, sets the parameters on the underlying java.util.ConcurrentHashMap used for storing region entries.") Integer initialCapacity, @ShellOption(value={"load-factor"}, help="Together with --initial-capacity, sets the parameters on the underlying java.util.ConcurrentHashMap used for storing region entries. This must be a floating point number between 0 and 1, inclusive.") Float loadFactor, @ShellOption(value={"lru-action"}, help="Action to take when evicting entries from the region. Valid values are: none, overflow-to-disk and local-destroy.") String lruEvictionAction, @ShellOption(value={"lru-algorithm"}, help="Least recently used eviction algorithm.  Valid values are: none, lru-entry-count, lru-heap-percentage and lru-memory-size.") String lruEvictionAlgo, @ShellOption(value={"lru-limit"}, help="Number of entries allowed in the region before eviction will occur.") Integer lruEvictionLimit, @ShellOption(value={"off-heap"}, help="Whether to use off-heap memory for the region. Valid values are: true and false.") Boolean offHeap, @ShellOption(value={"remove"}, help="Whether to remove the region from the disk store.", defaultValue="false") boolean remove) {
        String validatedDirectories = DiskStoreCommandsUtils.validatedDirectories(diskDirs);
        if (validatedDirectories != null) {
            throw new IllegalArgumentException("Could not find disk-dirs: \"" + validatedDirectories + "\"");
        }
        try {
            File[] dirs = null;
            if (diskDirs != null) {
                dirs = new File[diskDirs.length];
                for (int i = 0; i < diskDirs.length; ++i) {
                    dirs[i] = new File(diskDirs[i]);
                }
            }
            if (regionName.equals("/")) {
                return ResultModel.createError("Invalid region name");
            }
            if (lruEvictionAlgo != null || lruEvictionAction != null || lruEvictionLimit != null || concurrencyLevel != null || initialCapacity != null || loadFactor != null || compressorClassName != null || offHeap != null || statisticsEnabled != null) {
                if (!remove) {
                    String offHeapString;
                    String lruEvictionLimitString = lruEvictionLimit == null ? null : lruEvictionLimit.toString();
                    String concurrencyLevelString = concurrencyLevel == null ? null : concurrencyLevel.toString();
                    String initialCapacityString = initialCapacity == null ? null : initialCapacity.toString();
                    String loadFactorString = loadFactor == null ? null : loadFactor.toString();
                    String statisticsEnabledString = statisticsEnabled == null ? null : statisticsEnabled.toString();
                    String string = offHeapString = offHeap == null ? null : offHeap.toString();
                    if ("none".equals(compressorClassName)) {
                        compressorClassName = "";
                    }
                    String resultMessage = DiskStoreImpl.modifyRegion((String)diskStoreName, (File[])dirs, (String)("/" + regionName), (String)lruEvictionAlgo, (String)lruEvictionAction, (String)lruEvictionLimitString, (String)concurrencyLevelString, (String)initialCapacityString, (String)loadFactorString, (String)compressorClassName, (String)statisticsEnabledString, (String)offHeapString, (boolean)false);
                    return ResultModel.createInfo(resultMessage);
                }
                return ResultModel.createError("Cannot use the --remove=true parameter with any other parameters");
            }
            if (remove) {
                DiskStoreImpl.destroyRegion((String)diskStoreName, (File[])dirs, (String)("/" + regionName));
                return ResultModel.createInfo("The region " + regionName + " was successfully removed from the disk store " + diskStoreName);
            }
            return ResultModel.createInfo("Please provide a relevant parameter");
        }
        catch (IllegalArgumentException e) {
            return ResultModel.createError("Please check the parameters. " + e.getMessage());
        }
        catch (CacheExistsException e) {
            return ResultModel.createError("Cannot execute alter disk-store when a cache exists (Offline command)");
        }
        catch (Exception e) {
            return ResultModel.createError(e.getMessage());
        }
    }
}

