/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.datasource.ConfigProperty;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.internal.util.DriverJarUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class CreateJndiBindingFunction
extends CliFunction<Object[]> {
    private static final Logger logger = LogService.getLogger();
    private static final String ID = "org.apache.geode.management.internal.cli.functions.CreateJndiBindingFunction";

    public String getId() {
        return ID;
    }

    @Override
    public CliFunctionResult executeFunction(FunctionContext<Object[]> context) {
        Object[] arguments = (Object[])context.getArguments();
        JndiBindingsType.JndiBinding configuration = (JndiBindingsType.JndiBinding)arguments[0];
        boolean creatingDataSource = (Boolean)arguments[1];
        String TYPE_NAME = creatingDataSource ? "data-source" : "jndi-binding";
        try {
            JNDIInvoker.mapDatasource(CreateJndiBindingFunction.getParamsAsMap(configuration), CreateJndiBindingFunction.convert(configuration.getConfigProperties()));
        }
        catch (Exception ex) {
            if (logger.isErrorEnabled()) {
                logger.error("create " + TYPE_NAME + " failed", (Throwable)ex);
            }
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, ex.getMessage());
        }
        return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.OK, String.format("Created %s \"%s\" on \"%s\".", TYPE_NAME, configuration.getJndiName(), context.getMemberName()));
    }

    static Map<String, String> getParamsAsMap(JndiBindingsType.JndiBinding binding) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("blocking-timeout-seconds", binding.getBlockingTimeoutSeconds());
        params.put("conn-pooled-datasource-class", binding.getConnPooledDatasourceClass());
        params.put("connection-url", binding.getConnectionUrl());
        params.put("idle-timeout-seconds", binding.getIdleTimeoutSeconds());
        params.put("init-pool-size", binding.getInitPoolSize());
        params.put("jdbc-driver-class", binding.getJdbcDriverClass());
        params.put("jndi-name", binding.getJndiName());
        params.put("login-timeout-seconds", binding.getLoginTimeoutSeconds());
        params.put("managed-conn-factory-class", binding.getManagedConnFactoryClass());
        params.put("max-pool-size", binding.getMaxPoolSize());
        params.put("password", binding.getPassword());
        params.put("transaction-type", binding.getTransactionType());
        params.put("type", binding.getType());
        params.put("user-name", binding.getUserName());
        params.put("xa-datasource-class", binding.getXaDatasourceClass());
        return params;
    }

    DriverJarUtils getDriverJarUtil() {
        return new DriverJarUtils();
    }

    static List<ConfigProperty> convert(List<JndiBindingsType.JndiBinding.ConfigProperty> properties) {
        return properties.stream().map(p -> {
            ConfigProperty prop = new ConfigProperty();
            prop.setName(p.getName());
            prop.setType(p.getType());
            prop.setValue(p.getValue());
            return prop;
        }).collect(Collectors.toList());
    }
}

