/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.shell;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.cli.CommandRequest;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.apache.geode.management.internal.web.domain.QueryParameterSource;
import org.apache.geode.management.internal.web.http.support.HttpRequester;
import org.apache.geode.management.internal.web.shell.MBeanAccessException;
import org.apache.geode.management.internal.web.shell.support.HttpMBeanProxyFactory;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.FileSystemResource;
import org.springframework.util.LinkedMultiValueMap;

public class HttpOperationInvoker
implements OperationInvoker {
    protected static final long DEFAULT_INITIAL_DELAY = TimeUnit.SECONDS.toMillis(1L);
    protected static final long DEFAULT_PERIOD = TimeUnit.MILLISECONDS.toMillis(2000L);
    @Immutable
    protected static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    protected static final String CMD_QUERY_PARAMETER = "cmd";
    protected static final String COMMANDS_URI = "/management/commands";
    protected static final String RESOURCES_REQUEST_PARAMETER = "resources";
    private Integer clusterId = -1;
    private final ScheduledExecutorService executorService;
    private final Gfsh gfsh;
    private final String baseUrl;
    private final Logger logger = LogService.getLogger();
    private volatile HttpRequester httpRequester;
    private boolean connected = false;

    public HttpOperationInvoker(Gfsh gfsh, String baseUrl, Properties securityProperties) {
        this.gfsh = gfsh;
        this.baseUrl = baseUrl;
        this.httpRequester = new HttpRequester(securityProperties);
        this.httpRequester.get(HttpRequester.createURI(baseUrl, "/ping", new String[0]), String.class);
        this.connected = true;
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.scheduleAtFixedRate(() -> {
            try {
                this.httpRequester.get(HttpRequester.createURI(baseUrl, "/ping", new String[0]), String.class);
            }
            catch (Exception e) {
                this.printDebug("An error occurred while connecting to the Manager's HTTP service: %1$s: ", e.getMessage());
                this.getGfsh().notifyDisconnect(this.toString());
                this.stop();
            }
        }, DEFAULT_INITIAL_DELAY, DEFAULT_PERIOD, DEFAULT_TIME_UNIT);
        this.clusterId = (Integer)this.getAttribute("GemFire:service=System,type=Distributed", "DistributedSystemId");
    }

    protected static void assertState(boolean validState, String message, Object ... args) {
        if (!validState) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    protected boolean isDebugEnabled() {
        return this.getGfsh().getDebug();
    }

    protected ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    protected Gfsh getGfsh() {
        return this.gfsh;
    }

    protected void printDebug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.printInfo(message, args);
        }
    }

    protected void printInfo(String message, Object ... args) {
        this.getGfsh().printAsInfo(String.format(message, args));
    }

    protected void printWarning(String message, Object ... args) {
        this.getGfsh().printAsWarning(String.format(message, args));
    }

    protected void printSevere(String message, Object ... args) {
        this.getGfsh().printAsSevere(String.format(message, args));
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isReady() {
        return this.isConnected();
    }

    @Override
    public Object getAttribute(String resourceName, String attributeName) {
        URI link = HttpRequester.createURI(this.baseUrl, "/mbean/attribute", "resourceName", resourceName, "attributeName", attributeName);
        try {
            return IOUtils.deserializeObject((byte[])this.httpRequester.get(link, byte[].class));
        }
        catch (IOException e) {
            throw new MBeanAccessException(String.format("De-serializing the result of accessing attribute (%1$s) on MBean (%2$s) failed!", resourceName, attributeName), e);
        }
        catch (ClassNotFoundException e) {
            throw new MBeanAccessException(String.format("The Class type of the result when accessing attribute (%1$s) on MBean (%2$s) was not found!", resourceName, attributeName), e);
        }
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    public DistributedSystemMXBean getDistributedSystemMXBean() {
        return this.getMBeanProxy(MBeanJMXAdapter.getDistributedSystemName(), DistributedSystemMXBean.class);
    }

    @Override
    public <T> T getMBeanProxy(ObjectName objectName, Class<T> mbeanInterface) {
        return HttpMBeanProxyFactory.createMBeanProxy(this, objectName, mbeanInterface);
    }

    @Override
    public Object invoke(String resourceName, String operationName, Object[] params, String[] signatures) {
        URI link = HttpRequester.createURI(this.baseUrl, "/mbean/operation", new String[0]);
        LinkedMultiValueMap content = new LinkedMultiValueMap();
        content.add((Object)"resourceName", (Object)resourceName);
        content.add((Object)"operationName", (Object)operationName);
        if (params != null) {
            for (Object param : params) {
                content.add((Object)"parameters", param);
            }
        }
        if (signatures != null) {
            for (String signature : signatures) {
                content.add((Object)"signature", (Object)signature);
            }
        }
        try {
            return IOUtils.deserializeObject((byte[])this.httpRequester.post(link, content, byte[].class));
        }
        catch (IOException e) {
            throw new MBeanAccessException(String.format("De-serializing the result from invoking operation (%1$s) on MBean (%2$s) failed!", resourceName, operationName), e);
        }
        catch (ClassNotFoundException e) {
            throw new MBeanAccessException(String.format("The Class type of the result from invoking operation (%1$s) on MBean (%2$s) was not found!", resourceName, operationName), e);
        }
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExpression) {
        URI link = HttpRequester.createURI(this.baseUrl, "/mbean/query", new String[0]);
        QueryParameterSource content = new QueryParameterSource(objectName, queryExpression);
        try {
            return (Set)IOUtils.deserializeObject((byte[])this.httpRequester.post(link, content, byte[].class));
        }
        catch (Exception e) {
            throw new MBeanAccessException(String.format("An error occurred while querying for MBean names using ObjectName pattern (%1$s) and Query expression (%2$s)!", objectName, queryExpression), e);
        }
    }

    @Override
    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.httpRequester = null;
        this.connected = false;
    }

    public String toString() {
        return String.format("GemFire Manager HTTP service @ %1$s", this.baseUrl);
    }

    @Override
    public String getRemoteVersion() {
        URI link = HttpRequester.createURI(this.baseUrl, "/version/release", new String[0]);
        return this.httpRequester.get(link, String.class);
    }

    @Override
    public String getRemoteGeodeSerializationVersion() {
        URI link = HttpRequester.createURI(this.baseUrl, "/version/geodeSerializationVersion", new String[0]);
        return this.httpRequester.get(link, String.class);
    }

    @Override
    public Object processCommand(CommandRequest command) {
        URI link = HttpRequester.createURI(this.baseUrl, COMMANDS_URI, CMD_QUERY_PARAMETER, command.getUserInput());
        if (command.hasFileList()) {
            LinkedMultiValueMap content = new LinkedMultiValueMap();
            for (File file : command.getFileList()) {
                content.add((Object)RESOURCES_REQUEST_PARAMETER, (Object)new FileSystemResource(file));
            }
            return this.httpRequester.post(link, content, String.class);
        }
        return this.httpRequester.executeWithResponseExtractor(link);
    }
}

