/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliAroundInterceptor;
import org.apache.geode.management.internal.cli.CommandRequest;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.remote.CommandExecutor;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.security.NotAuthorizedException;
import org.springframework.shell.core.ExecutionStrategy;
import org.springframework.shell.event.ParseResult;
import org.springframework.util.Assert;

public class GfshExecutionStrategy
implements ExecutionStrategy {
    private final Class<?> mutex = GfshExecutionStrategy.class;
    private Gfsh shell;
    private final LogWrapper logWrapper;

    GfshExecutionStrategy(Gfsh shell) {
        this.shell = shell;
        this.logWrapper = shell.getGfshFileLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ParseResult parseResult) {
        Method method = parseResult.getMethod();
        if (this.isShellOnly(method)) {
            Assert.notNull((Object)parseResult, (String)"Parse result required");
            Class<?> clazz = this.mutex;
            synchronized (clazz) {
                Assert.isTrue((boolean)this.isReadyForCommands(), (String)"Not yet ready for commands");
                Object exeuctionResult = new CommandExecutor(null).execute((GfshParseResult)parseResult);
                if (exeuctionResult instanceof ResultModel) {
                    return new CommandResult((ResultModel)exeuctionResult);
                }
                return exeuctionResult;
            }
        }
        if (!(parseResult instanceof GfshParseResult)) {
            throw new IllegalStateException("Configuration error!");
        }
        ResultModel resultModel = this.executeOnRemote((GfshParseResult)parseResult);
        if (resultModel == null) {
            return null;
        }
        return new CommandResult(resultModel);
    }

    private boolean isShellOnly(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null && cliMetadata.shellOnly();
    }

    private String getInterceptor(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null ? cliMetadata.interceptor() : "__NULL__";
    }

    public boolean isReadyForCommands() {
        return true;
    }

    public void terminate() {
        this.shell = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultModel executeOnRemote(GfshParseResult parseResult) {
        Path tempFile = null;
        if (!this.shell.isConnectedAndReady()) {
            this.shell.logWarning("Can't execute a remote command without connection. Use 'connect' first to connect.", null);
            this.logWrapper.info("Can't execute a remote command \"" + parseResult.getUserInput() + "\" without connection. Use 'connect' first to connect to GemFire.");
            return null;
        }
        List<File> fileData = null;
        CliAroundInterceptor interceptor = null;
        String interceptorClass = this.getInterceptor(parseResult.getMethod());
        if (!"__NULL__".equals(interceptorClass)) {
            try {
                interceptor = (CliAroundInterceptor)ClassPathLoader.getLatest().forName(interceptorClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.shell.logWarning("Configuration error", e);
            }
            if (interceptor == null) {
                return ResultModel.createError("Interceptor Configuration Error");
            }
            ResultModel preExecResult = interceptor.preExecution(parseResult);
            if (preExecResult.getStatus() != Result.Status.OK) {
                return preExecResult;
            }
            fileData = preExecResult.getFileList();
        }
        Object response = null;
        Map<String, String> env = this.shell.getEnv();
        try {
            response = this.shell.getOperationInvoker().processCommand(new CommandRequest(parseResult, env, fileData));
            if (response == null) {
                ResultModel resultModel = ResultModel.createError("Response was null for: " + parseResult.getUserInput());
                return resultModel;
            }
        }
        catch (NotAuthorizedException e) {
            ResultModel resultModel = ResultModel.createError("Unauthorized. Reason : " + e.getMessage());
            return resultModel;
        }
        catch (Exception e) {
            this.shell.logSevere(e.getMessage(), e);
            ResultModel resultModel = ResultModel.createError("Error occurred while executing \"" + parseResult.getUserInput() + "\" on manager.");
            return resultModel;
        }
        finally {
            env.clear();
        }
        ResultModel commandResult = null;
        if (response instanceof String) {
            try {
                commandResult = ResultModel.fromJson((String)response);
            }
            catch (Exception e) {
                this.logWrapper.severe("Unable to parse the remote response.", e);
                String clientVersion = GemFireVersion.getGemFireVersion();
                String remoteVersion = null;
                try {
                    remoteVersion = this.shell.getOperationInvoker().getRemoteVersion();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String message = "Unable to parse the remote response. This might due to gfsh client version(" + clientVersion + ") mismatch with the remote cluster version" + (remoteVersion == null ? "." : "(" + remoteVersion + ").");
                return ResultModel.createError(message);
            }
        }
        if (response instanceof Path) {
            tempFile = (Path)response;
        }
        if (interceptor != null) {
            try {
                commandResult = interceptor.postExecution(parseResult, commandResult, tempFile);
            }
            catch (Exception e) {
                this.logWrapper.severe("error running post interceptor", e);
                commandResult = ResultModel.createError(e.getMessage());
            }
        }
        if (commandResult == null) {
            commandResult = ResultModel.createError("Unable to build ResultModel using the remote response.");
        }
        return commandResult;
    }
}

