/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.MultiIndexCreationException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.functions.CliFunctionResult;

public class CreateDefinedIndexesFunction
implements InternalFunction<Set<RegionConfig.Index>> {
    private static final long serialVersionUID = 6756381106602823693L;

    public String getId() {
        return CreateDefinedIndexesFunction.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FunctionContext<Set<RegionConfig.Index>> context) {
        Cache cache = context.getCache();
        QueryService queryService = cache.getQueryService();
        ResultSender sender = context.getResultSender();
        String memberId = cache.getDistributedSystem().getDistributedMember().getId();
        Set indexDefinitions = (Set)context.getArguments();
        try {
            for (Object indexDefinition : indexDefinitions) {
                String indexName = indexDefinition.getName();
                String regionPath = indexDefinition.getFromClause();
                String string = indexDefinition.getExpression();
                IndexType indexType = IndexType.valueOfSynonym((String)indexDefinition.getType());
                if (indexType == IndexType.PRIMARY_KEY) {
                    queryService.defineKeyIndex(indexName, string, regionPath);
                    continue;
                }
                if (indexType == IndexType.HASH) {
                    queryService.defineHashIndex(indexName, string, regionPath);
                    continue;
                }
                queryService.defineIndex(indexName, string, regionPath);
            }
            List indexes = queryService.createDefinedIndexes();
            if (!indexes.isEmpty()) {
                for (Index index : indexes) {
                    sender.sendResult((Object)new CliFunctionResult(memberId, true, "Created index " + index.getName()));
                }
            } else {
                sender.sendResult((Object)new CliFunctionResult(memberId, true, "No indexes defined"));
            }
        }
        catch (MultiIndexCreationException multiIndexCreationException) {
            ArrayList failedIndexes = new ArrayList(multiIndexCreationException.getFailedIndexNames());
            List createdIndexes = indexDefinitions.stream().filter(i -> !failedIndexes.contains(i.getName())).map(RegionConfig.Index::getName).collect(Collectors.toList());
            for (String string : createdIndexes) {
                sender.sendResult((Object)new CliFunctionResult(memberId, true, "Created index " + string));
            }
            for (Map.Entry entry : multiIndexCreationException.getExceptionsMap().entrySet()) {
                sender.sendResult((Object)new CliFunctionResult(memberId, false, String.format("Failed to create index %s: %s", entry.getKey(), ((Exception)entry.getValue()).getMessage())));
            }
        }
        catch (Exception ex) {
            sender.sendResult((Object)new CliFunctionResult(memberId, false, ex.getMessage()));
        }
        finally {
            queryService.clearDefinedIndexes();
        }
        sender.lastResult(null);
    }
}

