/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.logging.log4j.Logger;

public class NetstatFunction
implements InternalFunction<NetstatFunctionArgument> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    @Immutable
    public static final NetstatFunction INSTANCE = new NetstatFunction();
    private static final String ID = NetstatFunction.class.getName();
    private static final String NETSTAT_COMMAND = "netstat";
    private static final String LSOF_COMMAND = "lsof";

    public boolean hasResult() {
        return true;
    }

    public void execute(FunctionContext<NetstatFunctionArgument> context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
        if (ds == null || !ds.isConnected()) {
            return;
        }
        String host = ds.getDistributedMember().getHost();
        NetstatFunctionArgument args = (NetstatFunctionArgument)context.getArguments();
        boolean withlsof = args.isWithlsof();
        String lineSeparator = args.getLineSeparator();
        String netstatOutput = NetstatFunction.executeCommand(lineSeparator, withlsof);
        StringBuilder netstatInfo = new StringBuilder();
        NetstatFunction.addMemberHostHeader(netstatInfo, "{0}", host, lineSeparator);
        NetstatFunctionResult result = new NetstatFunctionResult(host, netstatInfo.toString(), CliUtil.compressBytes(netstatOutput.getBytes()));
        context.getResultSender().lastResult((Object)result);
    }

    private static void addMemberHostHeader(StringBuilder netstatInfo, String id, String host, String lineSeparator) {
        String osInfo = SystemUtils.getOsName() + " " + SystemUtils.getOsVersion() + " " + SystemUtils.getOsArchitecture();
        int nameIdLength = Math.max(Math.max(id.length(), host.length()), osInfo.length()) * 2;
        StringBuilder netstatInfoBottom = new StringBuilder();
        for (int i = 0; i < nameIdLength; ++i) {
            netstatInfo.append("#");
            netstatInfoBottom.append("#");
        }
        String memberPlatFormInfo = CliStrings.format((String)"Host: {1}{3}OS: {2}{3}Member(s):{3} {0}", (Object[])new Object[]{id, host, osInfo, lineSeparator});
        netstatInfo.append(lineSeparator).append(memberPlatFormInfo).append(lineSeparator).append(netstatInfoBottom.toString()).append(lineSeparator);
    }

    private static void addNetstatDefaultOptions(List<String> cmdOptionsList) {
        cmdOptionsList.add("-v");
        cmdOptionsList.add("-a");
        cmdOptionsList.add("-n");
        if (SystemUtils.isLinux()) {
            cmdOptionsList.add("-e");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeNetstat(StringBuilder netstatInfo, String lineSeparator) {
        ArrayList<String> cmdOptionsList = new ArrayList<String>();
        cmdOptionsList.add(NETSTAT_COMMAND);
        NetstatFunction.addNetstatDefaultOptions(cmdOptionsList);
        if (logger.isDebugEnabled()) {
            logger.debug("NetstatFunction executing {}", cmdOptionsList);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(cmdOptionsList);
        try {
            String line;
            Process netstat = processBuilder.start();
            InputStream is = netstat.getInputStream();
            BufferedReader breader = new BufferedReader(new InputStreamReader(is));
            while ((line = breader.readLine()) != null) {
                netstatInfo.append(line).append(lineSeparator);
            }
            netstat.destroy();
        }
        catch (IOException e) {
            netstatInfo.append(CliStrings.format((String)"Could not execute \"{0}\". Reason: {1}", (Object[])new Object[]{NETSTAT_COMMAND, e.getMessage()}));
        }
        finally {
            netstatInfo.append(lineSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeLsof(StringBuilder existingNetstatInfo, String lineSeparator) {
        existingNetstatInfo.append("################ ").append(LSOF_COMMAND).append(" output ###################").append(lineSeparator);
        if (SystemUtils.isLinux() || SystemUtils.isMacOSX() || SystemUtils.isSolaris()) {
            ArrayList<String> cmdOptionsList = new ArrayList<String>();
            cmdOptionsList.add(LSOF_COMMAND);
            cmdOptionsList.add("-n");
            cmdOptionsList.add("-P");
            ProcessBuilder procBuilder = new ProcessBuilder(cmdOptionsList);
            try {
                String line;
                Process lsof = procBuilder.start();
                InputStreamReader reader = new InputStreamReader(lsof.getInputStream());
                BufferedReader breader = new BufferedReader(reader);
                while ((line = breader.readLine()) != null) {
                    existingNetstatInfo.append(line).append(lineSeparator);
                }
                lsof.destroy();
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message.contains("error=2, No such file or directory")) {
                    existingNetstatInfo.append(CliStrings.format((String)"Could not execute \"{0}\". Reason: {1}", (Object[])new Object[]{LSOF_COMMAND, "lsof command not in current path"}));
                }
                existingNetstatInfo.append(CliStrings.format((String)"Could not execute \"{0}\". Reason: {1}", (Object[])new Object[]{LSOF_COMMAND, e.getMessage()}));
            }
            finally {
                existingNetstatInfo.append(lineSeparator);
            }
        } else {
            existingNetstatInfo.append("Not available for Windows.").append(lineSeparator);
        }
    }

    private static String executeCommand(String lineSeparator, boolean withlsof) {
        StringBuilder netstatInfo = new StringBuilder();
        NetstatFunction.executeNetstat(netstatInfo, lineSeparator);
        if (withlsof) {
            NetstatFunction.executeLsof(netstatInfo, lineSeparator);
        }
        return netstatInfo.toString();
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }

    public static void main(String[] args) {
        String netstat = NetstatFunction.executeCommand(GfshParser.LINE_SEPARATOR, true);
        System.out.println(netstat);
    }

    public static class NetstatFunctionResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String host;
        private final String headerInfo;
        private final CliUtil.DeflaterInflaterData compressedBytes;

        protected NetstatFunctionResult(String host, String headerInfo, CliUtil.DeflaterInflaterData compressedBytes) {
            this.host = host;
            this.headerInfo = headerInfo;
            this.compressedBytes = compressedBytes;
        }

        public String getHost() {
            return this.host;
        }

        public String getHeaderInfo() {
            return this.headerInfo;
        }

        public CliUtil.DeflaterInflaterData getCompressedBytes() {
            return this.compressedBytes;
        }
    }

    public static class NetstatFunctionArgument
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String lineSeparator;
        private final boolean withlsof;

        public NetstatFunctionArgument(String lineSeparator, boolean withlsof) {
            this.lineSeparator = lineSeparator;
            this.withlsof = withlsof;
        }

        public String getLineSeparator() {
            return this.lineSeparator;
        }

        public boolean isWithlsof() {
            return this.withlsof;
        }
    }
}

