/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.cli;

import java.util.Collections;
import java.util.Map;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.DependenciesNotFoundException;
import org.apache.geode.management.cli.CommandServiceException;
import org.apache.geode.management.cli.CommandStatement;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.remote.MemberCommandService;

public abstract class CommandService {
    @Immutable
    protected static final Map<String, String> EMPTY_ENV = Collections.emptyMap();
    @MakeNotStatic
    private static CommandService localCommandService;

    public abstract boolean isUsable();

    public abstract Result processCommand(String var1);

    protected abstract Result processCommand(String var1, Map<String, String> var2);

    public abstract CommandStatement createCommandStatement(String var1);

    protected abstract CommandStatement createCommandStatement(String var1, Map<String, String> var2);

    public static CommandService createLocalCommandService(Cache cache) throws CommandServiceException {
        if (cache == null) {
            throw new CacheClosedException("Can not create command service as cache doesn't exist.");
        }
        if (cache.isClosed()) {
            throw ((InternalCache)cache).getCacheClosedException("Can not create command service as cache is closed.");
        }
        if (localCommandService == null || !localCommandService.isUsable()) {
            String nonExistingDependency = CliUtil.cliDependenciesExist(false);
            if (nonExistingDependency != null) {
                throw new DependenciesNotFoundException(String.format("Could not find %s library which is needed for CLI/gfsh in classpath. Internal support for CLI & gfsh is not enabled. Note: For convenience, absolute path of gfsh-dependencies.jar from lib directory of GemFire product distribution can be included in CLASSPATH of an application.", nonExistingDependency));
            }
            localCommandService = new MemberCommandService((InternalCache)cache);
        }
        return localCommandService;
    }

    public static CommandService getUsableLocalCommandService() {
        if (localCommandService != null && localCommandService.isUsable()) {
            return localCommandService;
        }
        return null;
    }
}

