/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.functions.GarbageCollectionFunction;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class GCCommand
extends GfshCommand {
    @CliCommand(value={"gc"}, help="Force GC (Garbage Collection) on a member or members. The default is for garbage collection to occur on all caching members.")
    @CliMetaData(relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel gc(@CliOption(key={"group", "groups"}, help="Group(s) of members on which garbage collection will be done.") String[] groups, @CliOption(key={"member"}, optionContext="geode.converter.all.member.idOrName:disable-string-converter", help="Name/Id of the member on which garbage collection will be done.") String memberId) {
        Cache cache = this.getCache();
        ResultModel result = new ResultModel();
        TabularResultModel summary = result.addTable("summary");
        InfoResultModel errors = result.addInfo("errors");
        String headerText = "GC Summary";
        summary.setHeader(headerText);
        Set<Object> dsMembers = new HashSet();
        if (memberId != null && memberId.length() > 0) {
            String[] member = this.getMember(memberId);
            dsMembers.add(member);
        } else if (groups != null && groups.length > 0) {
            for (String group : groups) {
                dsMembers.addAll(cache.getDistributedSystem().getGroupMembers(group));
            }
        } else {
            dsMembers = this.getAllNormalMembers();
        }
        GarbageCollectionFunction garbageCollectionFunction = new GarbageCollectionFunction();
        List resultList = (List)ManagementUtils.executeFunction((Function)garbageCollectionFunction, null, dsMembers).getResult();
        for (Object object : resultList) {
            if (object == null) {
                errors.addLine("ResultMap was null");
                continue;
            }
            if (object instanceof Throwable) {
                errors.addLine("Exception in GC " + ((Throwable)object).getMessage());
                LogWrapper.getInstance(this.getCache()).fine("Exception in GC " + ((Throwable)object).getMessage(), (Throwable)object);
                continue;
            }
            if (object instanceof String) {
                errors.addLine((String)object);
                continue;
            }
            Map resultMap = (Map)object;
            summary.accumulate("Member ID/Name", (String)resultMap.get("MemberId"));
            summary.accumulate("HeapSize (MB) Before GC", (String)resultMap.get("HeapSizeBeforeGC"));
            summary.accumulate("HeapSize(MB) After GC", (String)resultMap.get("HeapSizeAfterGC"));
            summary.accumulate("Time Taken for GC in ms", (String)resultMap.get("TimeSpentInGC"));
        }
        return result;
    }
}

