/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.GfshParseResult;

public class CommandRequest {
    private final List<File> fileList;
    private final GfshParseResult parseResult;
    private final Map<String, String> env;
    private final boolean downloadFile;

    @VisibleForTesting
    public CommandRequest(Map<String, String> env) {
        this.env = env;
        this.fileList = null;
        this.parseResult = null;
        this.downloadFile = false;
    }

    public CommandRequest(Map<String, String> env, List<File> fileList) {
        this.env = env;
        this.fileList = fileList;
        this.parseResult = null;
        this.downloadFile = false;
    }

    public CommandRequest(GfshParseResult parseResult, Map<String, String> env, List<File> fileList) {
        assert (parseResult != null) : "The Gfsh ParseResult cannot be null!";
        assert (env != null) : "The reference to the Gfsh CLI environment cannot be null!";
        this.env = env;
        this.fileList = fileList;
        this.parseResult = parseResult;
        CliMetaData metaData = parseResult.getMethod().getDeclaredAnnotation(CliMetaData.class);
        this.downloadFile = metaData != null && metaData.isFileDownloadOverHttp();
    }

    public boolean isDownloadFile() {
        return this.downloadFile;
    }

    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this.env);
    }

    public List<File> getFileList() {
        return this.fileList;
    }

    public boolean hasFileList() {
        return this.getFileList() != null && this.getFileList().size() > 0;
    }

    protected GfshParseResult getParseResult() {
        return this.parseResult;
    }

    public String getUserInput() {
        return this.getParseResult().getUserInput();
    }
}

