/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.ExportLogsFunction;
import org.apache.geode.management.internal.cli.functions.SizeExportLogsFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.util.ExportLogsCacheWriter;
import org.apache.geode.management.internal.configuration.utils.ZipUtils;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ExportLogsCommand
extends GfshCommand {
    private static final Logger logger = LogService.getLogger();
    public static final String FORMAT = "yyyy/MM/dd/HH/mm/ss/SSS/z";
    public static final String ONLY_DATE_FORMAT = "yyyy/MM/dd";
    public static final String DEFAULT_EXPORT_LOG_LEVEL = "ALL";
    private static final Pattern DISK_SPACE_LIMIT_PATTERN = Pattern.compile("(\\d+)([kmgtKMGT]?)");
    static final long KILOBYTE = 1024L;
    static final long MEGABYTE = 0x100000L;
    static final long GIGABYTE = 0x40000000L;
    static final long TERABYTE = 0x10000000000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"export logs"}, help="Export the log files for a member or members.")
    @CliMetaData(isFileDownloadOverHttp=true, interceptor="org.apache.geode.management.internal.cli.commands.ExportLogsInterceptor", relatedTopic={"Server", "Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel exportLogs(@CliOption(key={"dir"}, help="Directory to which logs will be written.  This refers to a local directory when exporting logs using an http connection, but refers to the filesystem of the manager when connected via JMX. If not specified, logs are written to the location specified by the user.dir system property.") String dirName, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group of members whose log files will be exported.") String[] groups, @CliOption(key={"member", "members"}, optionContext="geode.converter.all.member.idOrName:disable-string-converter", help="Name/Id of the member whose log files will be exported.") String[] memberIds, @CliOption(key={"log-level"}, unspecifiedDefaultValue="ALL", optionContext="geode.converter.log.levels:disable-string-converter", help="Minimum level of log entries to export.  Possible values for log-level include: ALL, TRACE, DEBUG, INFO, WARN, ERROR, FATAL, OFF.  The default is ALL.") String logLevel, @CliOption(key={"only-log-level"}, unspecifiedDefaultValue="false", help="Whether to only include those entries that exactly match the --log-level specified.") boolean onlyLogLevel, @CliOption(key={"merge-log"}, unspecifiedDefaultValue="false", help="Whether to merge logs after exporting to the target directory. Deprecated: Since Geode 1.2, no longer used.") boolean mergeLog, @CliOption(key={"start-time"}, help="Log entries that occurred after this time will be exported. The default is no limit. Format: yyyy/MM/dd/HH/mm/ss/SSS/z OR yyyy/MM/dd") String start, @CliOption(key={"end-time"}, help="Log entries that occurred before this time will be exported. The default is no limit. Format: yyyy/MM/dd/HH/mm/ss/SSS/z OR yyyy/MM/dd") String end, @CliOption(key={"logs-only"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to only export logs") boolean logsOnly, @CliOption(key={"stats-only"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to only export statistics") boolean statsOnly, @CliOption(key={"file-size-limit"}, unspecifiedDefaultValue="100m", specifiedDefaultValue="0", help="Limits total unzipped size of the exported files. Specify zero for no limit. Value is in megabytes by default or [k|m|g|t] may be specified.") String fileSizeLimit) throws Exception {
        long totalEstimatedExportSize = 0L;
        InternalCache cache = (InternalCache)this.getCache();
        try {
            Object server;
            Set<DistributedMember> targetMembers = this.getMembersIncludingLocators(groups, memberIds);
            long userSpecifiedLimit = this.parseFileSizeLimit(fileSizeLimit);
            if (userSpecifiedLimit > 0L) {
                Object object = targetMembers.iterator();
                while (object.hasNext()) {
                    ExportLogsFunction.Args args = new ExportLogsFunction.Args(start, end, logLevel, onlyLogLevel, logsOnly, statsOnly);
                    server = object.next();
                    List results = (List)this.estimateLogSize(args, (DistributedMember)server).getResult();
                    if (results.isEmpty()) continue;
                    if (results.get(0) instanceof Long) {
                        long estimatedSize = (Long)results.get(0);
                        logger.info("Received estimated export size from member {}: {}", (Object)server.getId(), (Object)estimatedSize);
                        totalEstimatedExportSize += estimatedSize;
                        continue;
                    }
                    if (!(results.get(0) instanceof ManagementException)) continue;
                    ManagementException exception = (ManagementException)results.get(0);
                    ResultModel resultModel = ResultModel.createError(exception.getMessage());
                    return resultModel;
                }
                if (totalEstimatedExportSize > this.getLocalDiskAvailable()) {
                    object = ResultModel.createError("Estimated logs size will exceed the available disk space on the locator.");
                    return object;
                }
                if (totalEstimatedExportSize > userSpecifiedLimit) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Estimated exported logs expanded file size = ").append(totalEstimatedExportSize).append(", ").append("file-size-limit").append(" = ").append(userSpecifiedLimit).append(". To disable exported logs file size check use option \"--file-size-limit=0\".");
                    server = ResultModel.createError(sb.toString());
                    return server;
                }
            }
            HashMap<String, Path> zipFilesFromMembers = new HashMap<String, Path>();
            for (DistributedMember server2 : targetMembers) {
                Region region = ExportLogsFunction.createOrGetExistingExportLogsRegion(true, cache);
                ExportLogsCacheWriter cacheWriter = (ExportLogsCacheWriter)region.getAttributes().getCacheWriter();
                cacheWriter.startFile(server2.getName());
                this.executeFunction((Function)new ExportLogsFunction(), (Object)new ExportLogsFunction.Args(start, end, logLevel, onlyLogLevel, logsOnly, statsOnly), server2).getResult();
                Path zipFile = cacheWriter.endFile();
                ExportLogsFunction.destroyExportLogsRegion(cache);
                if (zipFile == null) continue;
                logger.info("Received zip file from member {}: {}", (Object)server2.getId(), (Object)zipFile);
                zipFilesFromMembers.put(server2.getId(), zipFile);
            }
            if (zipFilesFromMembers.isEmpty()) {
                server = ResultModel.createError("No files to be exported.");
                return server;
            }
            Path tempDir = Files.createTempDirectory("exportedLogs", new FileAttribute[0]);
            Path exportedLogsDir = tempDir.resolve("exportedLogs");
            FileUtils.forceMkdir((File)exportedLogsDir.toFile());
            for (Path zipFile : zipFilesFromMembers.values()) {
                Path unzippedMemberDir = exportedLogsDir.resolve(zipFile.getFileName().toString().replace(".zip", ""));
                ZipUtils.unzip((String)zipFile.toAbsolutePath().toString(), (String)unzippedMemberDir.toString());
                FileUtils.deleteQuietly((File)zipFile.toFile());
            }
            Path dirPath = StringUtils.isBlank((CharSequence)dirName) ? Paths.get(System.getProperty("user.dir"), new String[0]) : Paths.get(dirName, new String[0]);
            Path exportedLogsZipFile = dirPath.resolve("exportedLogs_" + System.currentTimeMillis() + ".zip").toAbsolutePath();
            logger.info("Zipping into: " + exportedLogsZipFile.toString());
            ZipUtils.zipDirectory((Path)exportedLogsDir, (Path)exportedLogsZipFile);
            FileUtils.deleteDirectory((File)tempDir.toFile());
            ResultModel result = new ResultModel();
            result.addFile(exportedLogsZipFile.toFile(), 2);
            ResultModel resultModel = result;
            return resultModel;
        }
        finally {
            ExportLogsFunction.destroyExportLogsRegion(cache);
        }
    }

    ResultCollector estimateLogSize(ExportLogsFunction.Args args, DistributedMember member) {
        return this.executeFunction((Function)new SizeExportLogsFunction(), (Object)args, member);
    }

    long getLocalDiskAvailable() {
        return FileUtils.getUserDirectory().getUsableSpace();
    }

    long parseFileSizeLimit(String fileSizeLimit) {
        if (StringUtils.isEmpty((CharSequence)fileSizeLimit)) {
            return 0L;
        }
        long sizeLimit = ExportLogsCommand.parseSize(fileSizeLimit);
        long byteMultiplier = ExportLogsCommand.parseByteMultiplier(fileSizeLimit);
        return sizeLimit * byteMultiplier;
    }

    static int parseSize(String diskSpaceLimit) {
        Matcher matcher = DISK_SPACE_LIMIT_PATTERN.matcher(diskSpaceLimit);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new IllegalArgumentException();
    }

    static long parseByteMultiplier(String diskSpaceLimit) {
        Matcher matcher = DISK_SPACE_LIMIT_PATTERN.matcher(diskSpaceLimit);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        switch (matcher.group(2).toLowerCase()) {
            case "k": {
                return 1024L;
            }
            case "t": {
                return 0x10000000000L;
            }
            case "g": {
                return 0x40000000L;
            }
        }
        return 0x100000L;
    }
}

