/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.functions.DestroyIndexFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyIndexCommand
extends SingleGfshCommand {
    @Immutable
    private static final DestroyIndexFunction destroyIndexFunction = new DestroyIndexFunction();

    @CliCommand(value={"destroy index"}, help="Destroy/Remove the specified index.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public ResultModel destroyIndex(@CliOption(key={"name"}, unspecifiedDefaultValue="", help="Name of the index to remove.") String indexName, @CliOption(key={"region"}, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region from which the index will be removed.") String regionPath, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member from which the index will be removed.") String[] memberNameOrID, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group of members from which the index will be removed.") String[] group, @CliOption(key={"if-exists"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="If true, the command will be a no-op if the entity does not exist.") boolean ifExists) {
        if (StringUtils.isBlank((CharSequence)indexName) && StringUtils.isBlank((CharSequence)regionPath) && ArrayUtils.isEmpty((Object[])group) && ArrayUtils.isEmpty((Object[])memberNameOrID)) {
            return ResultModel.createError(CliStrings.format((String)"\"{0}\" requires that one or more parameters be provided.", (Object)"destroy index"));
        }
        String regionName = null;
        if (regionPath != null) {
            regionName = regionPath.startsWith("/") ? regionPath.substring(1) : regionPath;
        }
        RegionConfig.Index indexInfo = new RegionConfig.Index();
        indexInfo.setName(indexName);
        indexInfo.setFromClause(regionName);
        Set<DistributedMember> targetMembers = this.findMembers(group, memberNameOrID);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        List<CliFunctionResult> funcResults = this.executeAndGetFunctionResult((Function)destroyIndexFunction, indexInfo, targetMembers);
        ResultModel result = ResultModel.createMemberStatusResult(funcResults, ifExists);
        result.setConfigObject(indexInfo);
        return result;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object element) {
        RegionConfig.Index indexFromCommand = (RegionConfig.Index)element;
        String indexName = indexFromCommand.getName();
        String regionName = indexFromCommand.getFromClause();
        if (regionName != null) {
            RegionConfig regionConfig = config.findRegionConfiguration(regionName);
            if (regionConfig == null) {
                String errorMessage = "Region " + regionName + " not found";
                if (!"cluster".equals(group)) {
                    errorMessage = errorMessage + " in group " + group;
                }
                throw new EntityNotFoundException(errorMessage);
            }
            if (indexName.isEmpty()) {
                regionConfig.getIndexes().clear();
            } else {
                Identifiable.remove((List)regionConfig.getIndexes(), (String)indexName);
            }
        } else {
            for (RegionConfig r : config.getRegions()) {
                Identifiable.remove((List)r.getIndexes(), (String)indexName);
            }
        }
        return true;
    }
}

