/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.functions.UnregisterFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyFunctionCommand
extends GfshCommand {
    @CliCommand(value={"destroy function"}, help="Destroy/Unregister a function. The default is for the function to be unregistered from all members.")
    @CliMetaData(relatedTopic={"Function Execution"}, interceptor="org.apache.geode.management.internal.cli.commands.DestroyFunctionCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DEPLOY)
    public ResultModel destroyFunction(@CliOption(key={"id"}, mandatory=true, help="Destroy/Unregister a function. The default is for the function to be unregistered from all members.") String functionId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Groups of members from which this function will be unregistered.") String[] groups, @CliOption(key={"member"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member from which this function will be unregistered.") String memberId) {
        try {
            Cache cache = this.getCache();
            HashSet<DistributedMember> dsMembers = new HashSet<DistributedMember>();
            if (groups != null && memberId != null) {
                return ResultModel.createError("Provide either --groups or --member");
            }
            if (groups != null && groups.length > 0) {
                for (String grp : groups) {
                    dsMembers.addAll(cache.getDistributedSystem().getGroupMembers(grp));
                }
                return this.executeFunction(cache, dsMembers, functionId);
            }
            if (memberId != null) {
                dsMembers.add(this.getMember(memberId));
                return this.executeFunction(cache, dsMembers, functionId);
            }
            return this.executeFunction(cache, cache.getMembers(), functionId);
        }
        catch (Exception e) {
            return ResultModel.createError(e.getMessage());
        }
    }

    private ResultModel executeFunction(Cache cache, Set<DistributedMember> DsMembers, String functionId) {
        ArrayList resultList;
        UnregisterFunction unregisterFunction = new UnregisterFunction();
        FunctionService.registerFunction((Function)unregisterFunction);
        if (DsMembers.isEmpty()) {
            return ResultModel.createInfo("No members for execution");
        }
        Object[] obj = new Object[]{functionId};
        Execution execution = FunctionService.onMembers(DsMembers).setArguments((Object)obj);
        if (execution == null) {
            cache.getLogger().error("executeUnregister execution is null");
            return ResultModel.createError("Cannot execute");
        }
        try {
            resultList = (ArrayList)execution.execute((Function)unregisterFunction).getResult();
        }
        catch (FunctionException ex) {
            return ResultModel.createError(ex.getMessage());
        }
        String resultStr = (String)resultList.get(0);
        if (resultStr.equals("Succeeded in unregistering")) {
            StringBuilder members = new StringBuilder();
            for (DistributedMember member : DsMembers) {
                members.append(member.getId());
                members.append(",");
            }
            return ResultModel.createInfo("Destroyed " + functionId + " Successfully on " + members.toString().substring(0, members.toString().length() - 1));
        }
        return ResultModel.createInfo("Failed in unregistering");
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            String onGroup = parseResult.getParamValueAsString("group");
            String onMember = parseResult.getParamValueAsString("member");
            String functionId = parseResult.getParamValueAsString("id");
            if (onGroup == null && onMember == null) {
                AbstractCliAroundInterceptor.Response response = this.readYesNo("Do you really want to destroy " + functionId + " on entire DS?", AbstractCliAroundInterceptor.Response.NO);
                if (response == AbstractCliAroundInterceptor.Response.NO) {
                    return ResultModel.createError("Aborted destroy of " + functionId);
                }
                return ResultModel.createInfo("Destroying " + functionId);
            }
            return ResultModel.createInfo("Destroying " + functionId);
        }
    }
}

