/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteStreamServer;
import com.healthmarketscience.rmiio.SimpleRemoteInputStream;
import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.internal.DeployedJar;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.ManagementAgent;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.functions.DeployFunction;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DeployCommand
extends GfshCommand {
    private final DeployFunction deployFunction = new DeployFunction();

    @CliCommand(value={"deploy"}, help="Deploy JARs to a member or members.  Only one of either --jar or --dir may be specified.")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.DeployCommand$Interceptor", isFileUploaded=true, relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DEPLOY)
    public ResultModel deploy(@CliOption(key={"group", "groups"}, help="Group(s) to which the specified JARs will be deployed. If not specified, deploy will occur on all members.", optionContext="geode.converter.member.groups:disable-string-converter") String[] groups, @CliOption(key={"jar", "jars"}, optionContext="geode.converter.jarfiles:disable-string-converter", help="Path of the JAR to deploy.") String[] jars, @CliOption(key={"dir"}, optionContext="geode.converter.jardir:disable-string-converter", help="Directory from which to deploy the JARs.") String dir) throws IOException {
        ResultModel result = new ResultModel();
        TabularResultModel deployResult = result.addTable("deployResult");
        List<String> jarFullPaths = CommandExecutionContext.getFilePathFromShell();
        this.verifyJarContent(jarFullPaths);
        Set<DistributedMember> targetMembers = this.findMembers(groups, null);
        ArrayList results = new ArrayList();
        ManagementAgent agent = ((SystemManagementService)this.getManagementService()).getManagementAgent();
        RemoteStreamExporter exporter = agent.getRemoteStreamExporter();
        for (DistributedMember distributedMember : targetMembers) {
            ArrayList<Object> remoteStreams = new ArrayList<Object>();
            ArrayList<String> jarNames = new ArrayList<String>();
            for (String jarFullPath : jarFullPaths) {
                remoteStreams.add(exporter.export((RemoteStreamServer)new SimpleRemoteInputStream((InputStream)new FileInputStream(jarFullPath))));
                jarNames.add(FilenameUtils.getName((String)jarFullPath));
            }
            ResultCollector<?, ?> resultCollector = this.executeFunction((Function)this.deployFunction, (Object)new Object[]{jarNames, remoteStreams}, distributedMember);
            results.add(((List)resultCollector.getResult()).get(0));
            for (RemoteInputStream remoteInputStream : remoteStreams) {
                try {
                    remoteInputStream.close(true);
                }
                catch (IOException iOException) {}
            }
        }
        List cleanedResults = CliFunctionResult.cleanResults(results);
        deployResult.setColumnHeader("Member", "Deployed JAR", "Deployed JAR Location");
        for (CliFunctionResult cliResult : cleanedResults) {
            if (cliResult.getThrowable() != null) {
                deployResult.addRow(cliResult.getMemberIdOrName(), "", "ERROR: " + cliResult.getThrowable().getClass().getName() + ": " + cliResult.getThrowable().getMessage());
                result.setStatus(Result.Status.ERROR);
                continue;
            }
            String[] strings = (String[])cliResult.getSerializables();
            for (int i = 0; i < strings.length; i += 2) {
                deployResult.addRow(cliResult.getMemberIdOrName(), strings[i], strings[i + 1]);
            }
        }
        if (result.getStatus() == Result.Status.OK) {
            InternalConfigurationPersistenceService internalConfigurationPersistenceService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
            if (internalConfigurationPersistenceService == null) {
                result.addInfo().addLine("Cluster configuration service is not running. Configuration change is not persisted.");
            } else {
                internalConfigurationPersistenceService.addJarsToThisLocator(jarFullPaths, groups);
            }
        }
        return result;
    }

    private void verifyJarContent(List<String> jarNames) {
        for (String jarName : jarNames) {
            File jar = new File(jarName);
            if (DeployedJar.hasValidJarContent((File)jar)) continue;
            throw new IllegalArgumentException("File does not contain valid JAR content: " + jar.getName());
        }
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        private final DecimalFormat numFormatter = new DecimalFormat("###,##0.00");

        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            String message;
            Object[] jars = (String[])parseResult.getParamValue("jar");
            String dir = (String)parseResult.getParamValue("dir");
            if (ArrayUtils.isEmpty((Object[])jars) && StringUtils.isBlank((CharSequence)dir)) {
                return ResultModel.createError("Parameter \"jar\" or \"dir\" is required. Use \"help <command name>\" for assistance.");
            }
            if (ArrayUtils.isNotEmpty((Object[])jars) && StringUtils.isNotBlank((CharSequence)dir)) {
                return ResultModel.createError("Parameters \"jar\" and \"dir\" can not both be specified.");
            }
            ResultModel result = new ResultModel();
            if (jars != null) {
                for (Object jar : jars) {
                    File jarFile = new File((String)jar);
                    if (!jarFile.exists()) {
                        return ResultModel.createError((String)jar + " not found.");
                    }
                    result.addFile(jarFile, 2);
                }
            } else {
                File[] childJarFile;
                File fileDir = new File(dir);
                if (!fileDir.isDirectory()) {
                    return ResultModel.createError(dir + " is not a directory");
                }
                for (File file : childJarFile = fileDir.listFiles(ManagementUtils.JAR_FILE_FILTER)) {
                    result.addFile(file, 2);
                }
            }
            if (this.readYesNo(message = "\nDeploying files: " + result.getFormattedFileList() + "\nTotal file size is: " + this.numFormatter.format((double)result.computeFileSizeTotal() / 1048576.0) + "MB\n\nContinue? ", AbstractCliAroundInterceptor.Response.YES) == AbstractCliAroundInterceptor.Response.NO) {
                return ResultModel.createError("Aborted deploy of " + result.getFormattedFileList() + ".");
            }
            return result;
        }
    }
}

