/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.HeadlessGfsh;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.test.dunit.IgnoredException;
import org.apache.geode.test.junit.assertions.CommandResultAssert;
import org.apache.geode.test.junit.rules.ConnectionConfiguration;
import org.apache.geode.test.junit.rules.DescribedExternalResource;
import org.apache.geode.test.junit.rules.Member;
import org.apache.geode.test.process.JavaModuleHelper;
import org.assertj.core.api.Assertions;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;

public class GfshCommandRule
extends DescribedExternalResource {
    private final Supplier<Integer> portSupplier;
    private PortType portType = PortType.jmxManager;
    private HeadlessGfsh gfsh = null;
    private int gfshTimeout = 2;
    private boolean connected = false;
    private IgnoredException ignoredException;
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File workingDir;
    private CommandResult commandResult;

    public GfshCommandRule() {
        this(null, null);
    }

    public GfshCommandRule(Supplier<Integer> portSupplier, PortType portType) {
        this.createTempFolder();
        this.portType = portType;
        this.portSupplier = portSupplier;
    }

    protected void before(Description description) throws Throwable {
        LogWrapper.close();
        this.createTempFolder();
        try {
            this.workingDir = this.temporaryFolder.newFolder("gfsh_files");
        }
        catch (IOException e) {
            this.workingDir = this.temporaryFolder.getRoot();
        }
        this.gfsh = new HeadlessGfsh(((Object)((Object)this)).getClass().getName(), this.gfshTimeout, this.workingDir.getAbsolutePath());
        this.ignoredException = IgnoredException.addIgnoredException("java.rmi.NoSuchObjectException: no such object in table");
        if (this.portSupplier == null) {
            return;
        }
        ConnectionConfiguration config = (ConnectionConfiguration)description.getAnnotation(ConnectionConfiguration.class);
        if (config == null) {
            this.connectAndVerify((int)this.portSupplier.get(), this.portType, new String[0]);
        } else {
            this.secureConnect(this.portSupplier.get(), this.portType, config.user(), config.password());
        }
    }

    protected void after(Description description) throws Throwable {
        this.close();
        if (this.ignoredException != null) {
            this.ignoredException.remove();
        }
    }

    private void createTempFolder() {
        try {
            this.temporaryFolder.getRoot();
        }
        catch (IllegalStateException e) {
            try {
                this.temporaryFolder.create();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
    }

    public void connect(Member locator, String ... options) throws Exception {
        this.connect(locator.getPort(), PortType.locator, options);
    }

    public void connectAndVerify(Member locator, String ... options) throws Exception {
        this.connect(locator.getPort(), PortType.locator, options);
        Assertions.assertThat((boolean)this.connected).isTrue();
    }

    public void connectAndVerify(int port, PortType type, Properties properties) throws Exception {
        this.connect(port, type, properties);
        Assertions.assertThat((boolean)this.connected).isTrue();
    }

    public void connectAndVerify(int port, PortType type, String ... options) throws Exception {
        this.connect(port, type, options);
        Assertions.assertThat((boolean)this.connected).isTrue();
    }

    public void secureConnect(int port, PortType type, String username, String password) throws Exception {
        this.connect(port, type, "user", username, "password", password);
    }

    public void secureConnectAndVerify(int port, PortType type, String username, String password) throws Exception {
        this.connect(port, type, "user", username, "password", password);
        Assertions.assertThat((boolean)this.connected).isTrue();
    }

    public void secureConnectWithTokenAndVerify(int port, PortType portType, String token) throws Exception {
        this.connect(port, portType, "token", token);
        Assertions.assertThat((boolean)this.connected).isTrue();
    }

    public void connect(int port, PortType type, Properties properties) throws Exception {
        File propertyFile = this.temporaryFolder.newFile();
        FileOutputStream out = new FileOutputStream(propertyFile);
        properties.store(out, null);
        this.connect(port, type, "security-properties-file", propertyFile.getAbsolutePath());
    }

    public void connect(int port, PortType type, String ... options) throws Exception {
        if (this.gfsh == null) {
            String absolutePath;
            try {
                absolutePath = this.temporaryFolder.newFolder("gfsh_files").getAbsolutePath();
            }
            catch (IOException e) {
                absolutePath = this.temporaryFolder.getRoot().getAbsolutePath();
            }
            this.gfsh = new HeadlessGfsh(((Object)((Object)this)).getClass().getName(), 30, absolutePath);
        }
        CommandStringBuilder connectCommand = new CommandStringBuilder("connect");
        if (type == PortType.locator) {
            endpoint = "localhost[" + port + "]";
            connectCommand.addOption("locator", endpoint);
        } else if (type == PortType.http || type == PortType.https) {
            endpoint = type.name() + "://localhost:" + port + "/geode-mgmt/v1";
            connectCommand.addOption("url", endpoint);
        } else {
            endpoint = "localhost[" + port + "]";
            connectCommand.addOption("jmx-manager", endpoint);
        }
        if (options != null) {
            for (int i = 0; i < options.length; i += 2) {
                connectCommand.addOption(options[i], options[i + 1]);
            }
        }
        CommandResult result = null;
        for (int i = 0; i < 50; ++i) {
            result = this.executeCommand(connectCommand.toString());
            if (!this.gfsh.outputString.contains("no such object in table")) break;
            Thread.sleep(2000L);
        }
        this.connected = result.getStatus() == Result.Status.OK;
    }

    public void disconnect() throws Exception {
        this.gfsh.clear();
        Gfsh gfshInstance = this.gfsh.getGfsh();
        if (gfshInstance != null && gfshInstance.getOperationInvoker() != null) {
            gfshInstance.getOperationInvoker().stop();
        }
        this.executeCommand("disconnect");
        this.connected = false;
    }

    public void close() throws Exception {
        this.temporaryFolder.delete();
        if (this.connected) {
            this.disconnect();
        }
        this.gfsh.executeCommand("exit");
        this.gfsh.terminate();
        LogWrapper.close();
        this.gfsh = null;
    }

    public Gfsh getGfsh() {
        return this.gfsh.getGfsh();
    }

    @Deprecated
    public CommandResult executeCommand(String command) {
        CommandResult result;
        String moduleArgs = "";
        if (command.matches("^start +server.*") || command.matches("^start +locator.*")) {
            moduleArgs = JavaModuleHelper.getJvmModuleOptions().stream().map(s -> "--J=" + s).collect(Collectors.joining(" ", " ", ""));
        }
        this.gfsh.executeCommand(command + moduleArgs);
        try {
            result = this.gfsh.getResult();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (StringUtils.isBlank((CharSequence)this.gfsh.outputString) && result != null) {
            this.gfsh.outputString = result.asString();
        }
        System.out.println("Command result for <" + command + ">: \n" + this.gfsh.outputString);
        this.commandResult = result;
        return result;
    }

    public CommandResultAssert executeAndAssertThat(String command) {
        this.commandResult = this.executeCommand(command);
        return new CommandResultAssert(this.commandResult);
    }

    public String getGfshOutput() {
        return this.gfsh.outputString;
    }

    public String execute(String command) throws Exception {
        this.executeCommand(command);
        return this.gfsh.outputString;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public Path getGfshLogFile() {
        if (this.gfsh == null) {
            throw new IllegalStateException("Gfsh has not been initialized");
        }
        return this.gfsh.getGfshLogFile();
    }

    public GfshCommandRule withTimeout(int timeoutInSeconds) {
        this.gfshTimeout = timeoutInSeconds;
        return this;
    }

    public CommandResult getCommandResult() {
        return this.commandResult;
    }

    public static enum PortType {
        locator,
        jmxManager,
        http,
        https;

    }
}

