/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.internal.InternalClientCache;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.test.dunit.Disconnect;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;
import org.assertj.core.api.Assertions;

public class ClientCacheRule
extends AbstractDistributedRule {
    private static volatile InternalClientCache clientCache;
    private final boolean createClientCache;
    private final boolean disconnectAfter;
    private final List<VM> createClientCacheInVMs;
    private final Properties config;
    private final Properties systemProperties;

    public static Builder builder() {
        return new Builder();
    }

    public ClientCacheRule() {
        this(new Builder());
    }

    public ClientCacheRule(int vmCount) {
        this(new Builder());
    }

    ClientCacheRule(Builder builder) {
        this.createClientCache = builder.createClientCache;
        this.disconnectAfter = builder.disconnectAfter;
        this.createClientCacheInVMs = builder.createClientCacheInVMs;
        this.config = builder.config;
        this.systemProperties = builder.systemProperties;
    }

    @Override
    protected void before() {
        if (this.createClientCache) {
            this.createClientCache(this.config, this.systemProperties);
        }
        for (VM vm : this.createClientCacheInVMs) {
            vm.invoke(() -> this.createClientCache(this.config, this.systemProperties));
        }
    }

    @Override
    protected void after() {
        ClientCacheRule.closeAndNullClientCache();
        this.invoker().invokeInEveryVMAndController(ClientCacheRule::closeAndNullClientCache);
        if (this.disconnectAfter) {
            Disconnect.disconnectAllFromDS();
        }
    }

    public InternalClientCache getClientCache() {
        return clientCache;
    }

    public InternalDistributedSystem getSystem() {
        return clientCache.getInternalDistributedSystem();
    }

    public void createClientCache() {
        clientCache = (InternalClientCache)new ClientCacheFactory(this.config).create();
    }

    public void createClientCache(ClientCacheFactory ClientCacheFactory2) {
        clientCache = (InternalClientCache)ClientCacheFactory2.create();
    }

    public void createClientCache(Properties config) {
        clientCache = (InternalClientCache)new ClientCacheFactory(config).create();
    }

    public void createClientCache(Properties config, Properties systemProperties) {
        System.getProperties().putAll((Map<?, ?>)systemProperties);
        clientCache = (InternalClientCache)new ClientCacheFactory(config).create();
    }

    public InternalClientCache getOrCreateClientCache() {
        if (clientCache == null) {
            this.createClientCache();
            Assertions.assertThat((Object)clientCache).isNotNull();
        }
        return clientCache;
    }

    private static void closeAndNullClientCache() {
        ClientCacheRule.closeClientCache();
        ClientCacheRule.nullClientCache();
    }

    private static void closeClientCache() {
        try {
            if (clientCache != null) {
                clientCache.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void nullClientCache() {
        clientCache = null;
    }

    public static class Builder {
        private final List<VM> createClientCacheInVMs = new ArrayList<VM>();
        private final Properties systemProperties = new Properties();
        private boolean createClientCache;
        private boolean disconnectAfter;
        private Properties config = new Properties();
        private int vmCount = VM.DEFAULT_VM_COUNT;

        public Builder createClientCacheIn(VM vm) {
            if (!this.createClientCacheInVMs.contains(vm)) {
                this.createClientCacheInVMs.add(vm);
            }
            return this;
        }

        public Builder createClientCacheInLocal() {
            this.createClientCache = true;
            return this;
        }

        public Builder disconnectAfter() {
            this.disconnectAfter = true;
            return this;
        }

        public Builder replaceConfig(Properties config) {
            this.config = config;
            return this;
        }

        public Builder addConfig(String key, String value) {
            this.config.put(key, value);
            return this;
        }

        public Builder addConfig(Properties config) {
            this.config.putAll((Map<?, ?>)config);
            return this;
        }

        public Builder addSystemProperty(String key, String value) {
            this.systemProperties.put(key, value);
            return this;
        }

        public Builder addSystemProperties(Properties config) {
            this.systemProperties.putAll((Map<?, ?>)config);
            return this;
        }

        public Builder vmCount(int vmCount) {
            this.vmCount = vmCount;
            return this;
        }

        public ClientCacheRule build() {
            return new ClientCacheRule(this);
        }
    }
}

