/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.ProcessHolder;
import org.apache.geode.test.dunit.internal.ProcessManager;
import org.apache.geode.test.dunit.internal.RemoteDUnitVM;
import org.apache.geode.test.dunit.internal.RemoteDUnitVMIF;
import org.apache.geode.test.dunit.internal.VMEventNotifier;
import org.apache.geode.test.version.VmConfiguration;

class DUnitHost
extends Host {
    private static final long serialVersionUID = -8034165624503666383L;
    private final transient VM debuggingVM = new VM(this, VmConfiguration.current(), -1, new RemoteDUnitVM(0), null, null);
    private final transient ProcessManager processManager;
    private final transient VMEventNotifier vmEventNotifier;

    DUnitHost(String hostName, ProcessManager processManager, VMEventNotifier vmEventNotifier) throws RemoteException {
        super(hostName, vmEventNotifier);
        this.processManager = processManager;
        this.vmEventNotifier = vmEventNotifier;
    }

    public void init(int numVMs, boolean launchLocator) throws RemoteException, NotBoundException, InterruptedException {
        for (int i = 0; i < numVMs; ++i) {
            RemoteDUnitVMIF remote = this.processManager.getStub(i);
            ProcessHolder processHolder = this.processManager.getProcessHolder(i);
            this.addVM(i, VmConfiguration.current(), remote, processHolder, this.processManager);
        }
        if (launchLocator) {
            this.addLocator(-2, this.processManager.getStub(-2), this.processManager.getProcessHolder(-2), this.processManager);
        }
        DUnitHost.addHost(this);
    }

    @Override
    public VM getVM(int n) {
        if (n < this.getVMCount() && n != -1) {
            VM current = super.getVM(n);
            return this.getVM(current.getVersion(), n);
        }
        return this.getVM("10240.0.0", n);
    }

    @Override
    public VM getVM(String geodeVersion, int whichVM) {
        return this.getVM(VmConfiguration.forGeodeVersion((String)geodeVersion), whichVM);
    }

    @Override
    public VM getVM(VmConfiguration configuration, int whichVM) {
        if (whichVM == -1) {
            return this.debuggingVM;
        }
        if (whichVM < this.getVMCount()) {
            VM current = super.getVM(whichVM);
            if (!current.getConfiguration().equals((Object)configuration)) {
                current.bounce(configuration, false);
            }
            return current;
        }
        int oldVMCount = this.getVMCount();
        if (whichVM >= oldVMCount) {
            try {
                int i;
                for (i = oldVMCount; i < whichVM; ++i) {
                    this.processManager.launchVM(i);
                }
                this.processManager.waitForVMs(120000L);
                for (i = oldVMCount; i < whichVM; ++i) {
                    this.addVM(i, VmConfiguration.current(), this.processManager.getStub(i), this.processManager.getProcessHolder(i), this.processManager);
                }
                this.processManager.launchVM(configuration, whichVM, false, 0);
                this.processManager.waitForVMs(120000L);
                this.addVM(whichVM, configuration, this.processManager.getStub(whichVM), this.processManager.getProcessHolder(whichVM), this.processManager);
            }
            catch (IOException | InterruptedException | NotBoundException e) {
                throw new RuntimeException("Could not dynamically launch vm + " + whichVM, e);
            }
        }
        return super.getVM(whichVM);
    }
}

