/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.templates;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.cache.operations.OperationContext;
import org.apache.geode.cache.operations.QueryOperationContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.security.AccessControl;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.templates.FunctionSecurityPrmsHolder;
import org.apache.geode.security.templates.XmlErrorHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlAuthorization
implements AccessControl {
    public static final String DOC_URI_PROP_NAME = "security-authz-xml-uri";
    private static final Object sync = new Object();
    private static final String EMPTY_VALUE = "";
    private static final String TAG_ROLE = "role";
    private static final String TAG_USER = "user";
    private static final String TAG_PERMS = "permission";
    private static final String TAG_OP = "operation";
    private static final String ATTR_ROLENAME = "name";
    private static final String ATTR_ROLE = "role";
    private static final String ATTR_REGIONS = "regions";
    private static final String ATTR_FUNCTION_IDS = "functionIds";
    private static final String ATTR_FUNCTION_OPTIMIZE_FOR_WRITE = "optimizeForWrite";
    private static final String ATTR_FUNCTION_KEY_SET = "keySet";
    private static String currentDocUri = null;
    private static Map<String, HashSet<String>> userRoles = null;
    private static Map<String, Map<String, Map<OperationContext.OperationCode, FunctionSecurityPrmsHolder>>> rolePermissions = null;
    private static NotAuthorizedException xmlLoadFailure = null;
    private final Map<String, Map<OperationContext.OperationCode, FunctionSecurityPrmsHolder>> allowedOps = new HashMap<String, Map<OperationContext.OperationCode, FunctionSecurityPrmsHolder>>();
    protected LogWriter systemLogWriter = null;
    protected LogWriter securityLogWriter = null;

    public static AccessControl create() {
        return new XmlAuthorization();
    }

    public static void clear() {
        currentDocUri = null;
        if (userRoles != null) {
            userRoles.clear();
            userRoles = null;
        }
        if (rolePermissions != null) {
            rolePermissions.clear();
            rolePermissions = null;
        }
        xmlLoadFailure = null;
    }

    public static String normalizeRegionName(String regionName) {
        if (regionName == null || regionName.length() == 0) {
            return EMPTY_VALUE;
        }
        char[] resultName = new char[regionName.length() + 1];
        boolean changed = false;
        boolean isPrevCharSlash = false;
        if (regionName.charAt(0) != '/') {
            changed = true;
            startIndex = 0;
        } else {
            isPrevCharSlash = true;
            startIndex = 1;
        }
        resultName[0] = 47;
        int resultLength = 1;
        for (int index = startIndex; index < regionName.length(); ++index) {
            char currChar = regionName.charAt(index);
            if (currChar == '/') {
                if (isPrevCharSlash) {
                    changed = true;
                    continue;
                }
                isPrevCharSlash = true;
            } else {
                isPrevCharSlash = false;
            }
            resultName[resultLength++] = currChar;
        }
        if (resultName[resultLength - 1] == '/') {
            --resultLength;
            changed = true;
        }
        if (changed) {
            return new String(resultName, 0, resultLength);
        }
        return regionName;
    }

    private XmlAuthorization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Principal principal, DistributedMember remoteMember, Cache cache) throws NotAuthorizedException {
        Object object = sync;
        synchronized (object) {
            XmlAuthorization.init(cache);
        }
        this.systemLogWriter = cache.getLogger();
        this.securityLogWriter = cache.getSecurityLogger();
        String name = principal != null ? principal.getName() : EMPTY_VALUE;
        HashSet<String> roles = userRoles.get(name);
        if (roles != null) {
            for (String roleName : roles) {
                Map<String, Map<OperationContext.OperationCode, FunctionSecurityPrmsHolder>> regionOperationMap = rolePermissions.get(roleName);
                if (regionOperationMap == null) continue;
                for (Map.Entry<String, Map<OperationContext.OperationCode, FunctionSecurityPrmsHolder>> regionEntry : regionOperationMap.entrySet()) {
                    String regionName = regionEntry.getKey();
                    Map<OperationContext.OperationCode, FunctionSecurityPrmsHolder> regionOperations = this.allowedOps.get(regionName);
                    if (regionOperations == null) {
                        regionOperations = new HashMap<OperationContext.OperationCode, FunctionSecurityPrmsHolder>();
                        this.allowedOps.put(regionName, regionOperations);
                    }
                    regionOperations.putAll(regionEntry.getValue());
                }
            }
        }
    }

    public boolean authorizeOperation(String regionName, OperationContext context) {
        if (context.isClientUpdate()) {
            Map<OperationContext.OperationCode, FunctionSecurityPrmsHolder> operationMap = this.allowedOps.get(regionName);
            if (operationMap == null && regionName.length() > 0) {
                operationMap = this.allowedOps.get(EMPTY_VALUE);
            }
            if (operationMap != null) {
                return operationMap.containsKey(OperationContext.OperationCode.GET);
            }
            return false;
        }
        OperationContext.OperationCode opCode = context.getOperationCode();
        if (opCode.isQuery() || opCode.isExecuteCQ() || opCode.isCloseCQ() || opCode.isStopCQ()) {
            Map<OperationContext.OperationCode, FunctionSecurityPrmsHolder> operationMap = this.allowedOps.get(EMPTY_VALUE);
            boolean globalPermission = operationMap != null && operationMap.containsKey(opCode);
            Set regionNames = ((QueryOperationContext)context).getRegionNames();
            if (regionNames == null || regionNames.size() == 0) {
                return globalPermission;
            }
            for (String r : regionNames) {
                regionName = XmlAuthorization.normalizeRegionName(r);
                operationMap = this.allowedOps.get(regionName);
                if (!(operationMap == null ? !globalPermission : !operationMap.containsKey(opCode))) continue;
                return false;
            }
            return true;
        }
        String normalizedRegionName = XmlAuthorization.normalizeRegionName(regionName);
        Map<OperationContext.OperationCode, FunctionSecurityPrmsHolder> operationMap = this.allowedOps.get(normalizedRegionName);
        if (operationMap == null && normalizedRegionName.length() > 0) {
            operationMap = this.allowedOps.get(EMPTY_VALUE);
        }
        if (operationMap != null) {
            if (context.getOperationCode() != OperationContext.OperationCode.EXECUTE_FUNCTION) {
                return operationMap.containsKey(context.getOperationCode());
            }
            if (!operationMap.containsKey(context.getOperationCode())) {
                return false;
            }
            if (!context.isPostOperation()) {
                FunctionSecurityPrmsHolder functionParameter = operationMap.get(context.getOperationCode());
                ExecuteFunctionOperationContext functionContext = (ExecuteFunctionOperationContext)context;
                if (functionContext.getRegionName() != null) {
                    if (functionParameter.isOptimizeForWrite() != null && functionParameter.isOptimizeForWrite().booleanValue() != functionContext.isOptimizeForWrite()) {
                        return false;
                    }
                    if (functionParameter.getFunctionIds() != null && !functionParameter.getFunctionIds().contains(functionContext.getFunctionId())) {
                        return false;
                    }
                    if (functionParameter.getKeySet() != null && functionContext.getKeySet() != null) {
                        return !functionContext.getKeySet().containsAll(functionParameter.getKeySet());
                    }
                    return true;
                }
                return functionParameter.getFunctionIds() == null || functionParameter.getFunctionIds().contains(functionContext.getFunctionId());
            }
            ExecuteFunctionOperationContext functionContext = (ExecuteFunctionOperationContext)context;
            FunctionSecurityPrmsHolder functionParameter = operationMap.get(context.getOperationCode());
            if (functionContext.getRegionName() != null) {
                if (functionContext.getResult() instanceof ArrayList && functionParameter.getKeySet() != null) {
                    Set<String> nonAllowedKeys;
                    ArrayList resultList = (ArrayList)functionContext.getResult();
                    return !resultList.containsAll(nonAllowedKeys = functionParameter.getKeySet());
                }
                return true;
            }
            ArrayList resultList = (ArrayList)functionContext.getResult();
            String inSecureItem = "Insecure item";
            return !resultList.contains("Insecure item");
        }
        return false;
    }

    public void close() {
        this.allowedOps.clear();
    }

    private static String getAttributeValue(Node node, String attrName) {
        Node attrNode;
        NamedNodeMap attrMap = node.getAttributes();
        if (attrMap != null && (attrNode = attrMap.getNamedItem(attrName)) != null) {
            return ((Attr)attrNode).getValue();
        }
        return EMPTY_VALUE;
    }

    private static String getNodeValue(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node childNode = childNodes.item(index);
            if (childNode.getNodeType() != 3) continue;
            return childNode.getNodeValue();
        }
        return EMPTY_VALUE;
    }

    private static void init(Cache cache) throws NotAuthorizedException {
        LogWriter systemLogWriter = cache.getLogger();
        String xmlDocumentUri = (String)cache.getDistributedSystem().getSecurityProperties().get(DOC_URI_PROP_NAME);
        try {
            if (xmlDocumentUri == null) {
                throw new NotAuthorizedException("No ACL file defined using tag [security-authz-xml-uri] in system properties");
            }
            if (xmlDocumentUri.equals(currentDocUri)) {
                if (xmlLoadFailure != null) {
                    throw xmlLoadFailure;
                }
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            XmlErrorHandler errorHandler = new XmlErrorHandler(systemLogWriter, xmlDocumentUri);
            builder.setErrorHandler(errorHandler);
            builder.setEntityResolver(new AuthzDtdResolver());
            Document xmlDocument = builder.parse(xmlDocumentUri);
            userRoles = new HashMap<String, HashSet<String>>();
            rolePermissions = new HashMap<String, Map<String, Map<OperationContext.OperationCode, FunctionSecurityPrmsHolder>>>();
            NodeList roleUserNodes = xmlDocument.getElementsByTagName("role");
            for (int roleIndex = 0; roleIndex < roleUserNodes.getLength(); ++roleIndex) {
                Node roleUserNode = roleUserNodes.item(roleIndex);
                String roleName = XmlAuthorization.getAttributeValue(roleUserNode, ATTR_ROLENAME);
                NodeList userNodes = roleUserNode.getChildNodes();
                for (int userIndex = 0; userIndex < userNodes.getLength(); ++userIndex) {
                    HashSet<String> userRoleSet;
                    Node userNode = userNodes.item(userIndex);
                    if (TAG_USER.equals(userNode.getNodeName())) {
                        String userName = XmlAuthorization.getNodeValue(userNode);
                        userRoleSet = userRoles.get(userName);
                        if (userRoleSet == null) {
                            userRoleSet = new HashSet();
                            userRoles.put(userName, userRoleSet);
                        }
                    } else {
                        throw new SAXParseException("Unknown tag [" + userNode.getNodeName() + "] as child of tag [role]", null);
                    }
                    userRoleSet.add(roleName);
                }
            }
            NodeList rolePermissionNodes = xmlDocument.getElementsByTagName(TAG_PERMS);
            for (int permIndex = 0; permIndex < rolePermissionNodes.getLength(); ++permIndex) {
                String[] regionNamesSplit;
                Node rolePermissionNode = rolePermissionNodes.item(permIndex);
                String roleName = XmlAuthorization.getAttributeValue(rolePermissionNode, "role");
                Map<String, Map<OperationContext.OperationCode, FunctionSecurityPrmsHolder>> regionOperationMap = rolePermissions.get(roleName);
                if (regionOperationMap == null) {
                    regionOperationMap = new HashMap<String, Map<OperationContext.OperationCode, FunctionSecurityPrmsHolder>>();
                    rolePermissions.put(roleName, regionOperationMap);
                }
                NodeList operationNodes = rolePermissionNode.getChildNodes();
                HashMap<OperationContext.OperationCode, FunctionSecurityPrmsHolder> operationMap = new HashMap<OperationContext.OperationCode, FunctionSecurityPrmsHolder>();
                for (int opIndex = 0; opIndex < operationNodes.getLength(); ++opIndex) {
                    Node operationNode = operationNodes.item(opIndex);
                    if (TAG_OP.equals(operationNode.getNodeName())) {
                        HashSet<String> keySet;
                        HashSet<String> functionIds;
                        String operationName = XmlAuthorization.getNodeValue(operationNode);
                        OperationContext.OperationCode code = OperationContext.OperationCode.valueOf((String)operationName);
                        if (code == null) {
                            throw new SAXParseException("Unknown operation [" + operationName + "]", null);
                        }
                        if (code != OperationContext.OperationCode.EXECUTE_FUNCTION) {
                            operationMap.put(code, null);
                            continue;
                        }
                        String optimizeForWrite = XmlAuthorization.getAttributeValue(operationNode, ATTR_FUNCTION_OPTIMIZE_FOR_WRITE);
                        String functionAttr = XmlAuthorization.getAttributeValue(operationNode, ATTR_FUNCTION_IDS);
                        String keysAttr = XmlAuthorization.getAttributeValue(operationNode, ATTR_FUNCTION_KEY_SET);
                        Boolean isOptimizeForWrite = optimizeForWrite == null || optimizeForWrite.length() == 0 ? null : Boolean.valueOf(Boolean.parseBoolean(optimizeForWrite));
                        if (functionAttr == null || functionAttr.length() == 0) {
                            functionIds = null;
                        } else {
                            String[] functionArray = functionAttr.split(",");
                            functionIds = new HashSet<String>();
                            for (String s : functionArray) {
                                functionIds.add(s);
                            }
                        }
                        if (keysAttr == null || keysAttr.length() == 0) {
                            keySet = null;
                        } else {
                            String[] keySetArray = keysAttr.split(",");
                            keySet = new HashSet<String>();
                            for (String s : keySetArray) {
                                keySet.add(s);
                            }
                        }
                        FunctionSecurityPrmsHolder functionContext = new FunctionSecurityPrmsHolder(isOptimizeForWrite, functionIds, keySet);
                        operationMap.put(code, functionContext);
                        continue;
                    }
                    throw new SAXParseException("Unknown tag [" + operationNode.getNodeName() + "] as child of tag [permission]", null);
                }
                String regionNames = XmlAuthorization.getAttributeValue(rolePermissionNode, ATTR_REGIONS);
                if (regionNames == null || regionNames.length() == 0) {
                    regionOperationMap.put(EMPTY_VALUE, operationMap);
                    continue;
                }
                for (String s : regionNamesSplit = regionNames.split(",")) {
                    regionOperationMap.put(XmlAuthorization.normalizeRegionName(s), operationMap);
                }
            }
            currentDocUri = xmlDocumentUri;
        }
        catch (Exception ex) {
            Object message = ex instanceof NotAuthorizedException ? ex.getMessage() : ex.getClass().getName() + ": " + ex.getMessage();
            systemLogWriter.warning("XmlAuthorization.init: " + (String)message);
            xmlLoadFailure = new NotAuthorizedException((String)message, (Throwable)ex);
            throw xmlLoadFailure;
        }
    }

    private static class AuthzDtdResolver
    implements EntityResolver {
        final Pattern authzPattern = Pattern.compile("authz.*\\.dtd");

        private AuthzDtdResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            try {
                Matcher matcher = this.authzPattern.matcher(systemId);
                if (matcher.find()) {
                    String dtdName = matcher.group(0);
                    InputStream stream = XmlAuthorization.class.getResourceAsStream(dtdName);
                    return new InputSource(stream);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

