/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache30;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache30.TestCacheListener;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.logging.log4j.Logger;

public class CertifiableTestCacheListener<K, V>
extends TestCacheListener<K, V> {
    private final Set<K> destroys = Collections.synchronizedSet(new HashSet());
    private final Set<K> creates = Collections.synchronizedSet(new HashSet());
    private final Set<K> invalidates = Collections.synchronizedSet(new HashSet());
    private final Set<K> updates = Collections.synchronizedSet(new HashSet());
    private static final Logger logger = LogService.getLogger();

    public void clearState() {
        this.destroys.clear();
        this.creates.clear();
        this.invalidates.clear();
        this.updates.clear();
    }

    @Override
    public List<CacheEvent<K, V>> getEventHistory() {
        this.destroys.clear();
        this.creates.clear();
        this.invalidates.clear();
        this.updates.clear();
        return super.getEventHistory();
    }

    @VisibleForTesting
    public Set<K> getDestroys() {
        return this.destroys;
    }

    @Override
    public void afterCreate2(EntryEvent<K, V> event) {
        this.creates.add(event.getKey());
    }

    @Override
    public void afterDestroy2(EntryEvent<K, V> event) {
        this.destroys.add(event.getKey());
    }

    @Override
    public void afterInvalidate2(EntryEvent<K, V> event) {
        this.invalidates.add(event.getKey());
    }

    @Override
    public void afterUpdate2(EntryEvent<K, V> event) {
        this.updates.add(event.getKey());
    }

    public boolean waitForCreated(K key) {
        GeodeAwaitility.await((String)("Waiting for key creation: " + String.valueOf(key))).until(() -> this.creates.contains(key));
        return true;
    }

    public boolean waitForDestroyed(K key) {
        GeodeAwaitility.await((String)("Waiting for key destroy: " + String.valueOf(key))).until(() -> this.destroys.contains(key));
        return true;
    }

    public boolean waitForInvalidated(K key) {
        GeodeAwaitility.await((String)("Waiting for key invalidate: " + String.valueOf(key))).until(() -> this.invalidates.contains(key));
        return true;
    }

    public boolean waitForUpdated(K key) {
        GeodeAwaitility.await((String)("Waiting for key update: " + String.valueOf(key))).until(() -> this.updates.contains(key));
        return true;
    }
}

