/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.functional;

import java.util.List;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.query.CacheUtils;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.data.Portfolio;
import org.apache.geode.cache.query.data.Position;
import org.apache.geode.cache.query.dunit.TestObject;
import org.apache.geode.cache.query.functional.OrderByTestImplementation;
import org.apache.geode.cache.query.functional.StructSetOrResultsSet;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.test.junit.categories.OQLQueryTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={OQLQueryTest.class})
public abstract class OrderByPartitionedJUnitTestBase
extends OrderByTestImplementation {
    @Override
    public Region createRegion(String regionName, Class valueConstraint) {
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        AttributesFactory af = new AttributesFactory();
        af.setPartitionAttributes(paf.create());
        af.setValueConstraint(valueConstraint);
        Region r1 = CacheUtils.createRegion((String)regionName, (RegionAttributes)af.create(), (boolean)false);
        return r1;
    }

    @Override
    public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        return CacheUtils.getQueryService().createIndex(indexName, indexType, indexedExpression, fromClause);
    }

    @Override
    public Index createIndex(String indexName, String indexedExpression, String regionPath) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        return CacheUtils.getQueryService().createIndex(indexName, indexedExpression, regionPath);
    }

    @Override
    public boolean assertIndexUsedOnQueryNode() {
        return true;
    }

    @Test
    public void testBug() throws Exception {
        int i;
        String[] queries = new String[]{"SELECT DISTINCT * FROM /test WHERE id < $1 ORDER BY id"};
        Object[][] r = new Object[queries.length][2];
        QueryService qs = CacheUtils.getQueryService();
        Position.resetCounter();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        AttributesFactory af = new AttributesFactory();
        Region r1 = CacheUtils.createRegion((String)"test", (RegionAttributes)af.create(), (boolean)false);
        for (i = 0; i < 100; ++i) {
            r1.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
        }
        for (i = 0; i < queries.length; ++i) {
            Query q = null;
            try {
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                r[i][0] = q.execute(new Object[]{101});
                Assert.assertEquals((long)100L, (long)((SelectResults)r[i][0]).size());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
    }

    @Test
    public void testOrderedResultsPartitionedRegion_Bug43514_1() throws Exception {
        Query q;
        int i;
        String[] queries = new String[]{"select distinct * from /portfolio1 p order by status, ID desc", "select distinct * from /portfolio1 p, p.positions.values val order by p.ID, val.secId desc", "select distinct p.status from /portfolio1 p order by p.status", "select distinct status, ID from /portfolio1 order by status, ID", "select distinct p.status, p.ID from /portfolio1 p order by p.status, p.ID", "select distinct key.ID from /portfolio1.keys key order by key.ID", "select distinct key.ID, key.status from /portfolio1.keys key order by key.status, key.ID", "select distinct key.ID, key.status from /portfolio1.keys key order by key.status desc, key.ID", "select distinct key.ID, key.status from /portfolio1.keys key order by key.status, key.ID desc", "select distinct p.status, p.ID from /portfolio1 p order by p.status asc, p.ID", "select distinct p.ID, p.status from /portfolio1 p order by p.ID desc, p.status asc", "select distinct p.ID from /portfolio1 p, p.positions.values order by p.ID", "select distinct p.ID, p.status from /portfolio1 p, p.positions.values order by p.status, p.ID", "select distinct pos.secId from /portfolio1 p, p.positions.values pos order by pos.secId", "select distinct p.ID, pos.secId from /portfolio1 p, p.positions.values pos order by pos.secId, p.ID", "select distinct p.iD from /portfolio1 p order by p.iD", "select distinct p.iD, p.status from /portfolio1 p order by p.iD", "select distinct iD, status from /portfolio1 order by iD", "select distinct p.getID() from /portfolio1 p order by p.getID()", "select distinct p.names[1] from /portfolio1 p order by p.names[1]", "select distinct p.position1.secId, p.ID from /portfolio1 p order by p.position1.secId desc, p.ID", "select distinct p.ID, p.position1.secId from /portfolio1 p order by p.position1.secId, p.ID", "select distinct e.key.ID from /portfolio1.entries e order by e.key.ID", "select distinct e.key.ID, e.value.status from /portfolio1.entries e order by e.key.ID", "select distinct e.key.ID, e.value.status from /portfolio1.entrySet e order by e.key.ID desc , e.value.status desc", "select distinct e.key, e.value from /portfolio1.entrySet e order by e.key.ID, e.value.status desc", "select distinct e.key from /portfolio1.entrySet e order by e.key.ID desc, e.key.pkid desc", "select distinct p.ID, pos.secId from /portfolio1 p, p.positions.values pos order by p.ID, pos.secId", "select distinct p.ID, pos.secId from /portfolio1 p, p.positions.values pos order by p.ID desc, pos.secId desc", "select distinct p.ID, pos.secId from /portfolio1 p, p.positions.values pos order by p.ID desc, pos.secId"};
        Object[][] r = new Object[queries.length][2];
        QueryService qs = CacheUtils.getQueryService();
        Position.resetCounter();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        AttributesFactory af = new AttributesFactory();
        af.setPartitionAttributes(paf.create());
        Region r1 = CacheUtils.createRegion((String)"portfolio1", (RegionAttributes)af.create(), (boolean)false);
        for (i = 0; i < 50; ++i) {
            r1.put((Object)new Portfolio(i), (Object)new Portfolio(i));
        }
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                r[i][0] = q.execute();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        this.createIndex("i1", IndexType.FUNCTIONAL, "p.status", "/portfolio1 p");
        this.createIndex("i2", IndexType.FUNCTIONAL, "p.ID", "/portfolio1 p");
        this.createIndex("i3", IndexType.FUNCTIONAL, "p.position1.secId", "/portfolio1 p");
        this.createIndex("i4", IndexType.FUNCTIONAL, "key.ID", "/portfolio1.keys key");
        this.createIndex("i5", IndexType.FUNCTIONAL, "key.status", "/portfolio1.keys key");
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                OrderByTestImplementation.QueryObserverImpl observer = new OrderByTestImplementation.QueryObserverImpl();
                QueryObserverHolder.setInstance((QueryObserver)observer);
                r[i][1] = q.execute();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        StructSetOrResultsSet ssOrrs = new StructSetOrResultsSet();
        ssOrrs.CompareQueryResultsWithoutAndWithIndexes(r, queries.length, true, queries);
    }

    @Test
    public void testOrderedResultsPartitionedRegion_Bug43514_2() throws Exception {
        Query q;
        int i;
        String[] queries = new String[]{"select distinct status as st from /portfolio1 where ID > 0 order by status", "select distinct p.status as st from /portfolio1 p where ID > 0 and status = 'inactive' order by p.status", "select distinct p.position1.secId as st from /portfolio1 p where p.ID > 0 and p.position1.secId != 'IBM' order by p.position1.secId", "select distinct  key.status as st from /portfolio1 key where key.ID > 5 order by key.status", "select distinct key.ID,key.status as st from /portfolio1 key where key.status = 'inactive' order by key.status desc, key.ID", "select distinct  status, ID from /portfolio1 order by status", "select distinct  p.status, p.ID from /portfolio1 p order by p.status", "select distinct p.position1.secId, p.ID from /portfolio1 p order by p.position1.secId", "select distinct p.status, p.ID from /portfolio1 p order by p.status asc, p.ID", "select distinct p.ID from /portfolio1 p, p.positions.values order by p.ID", "select distinct * from /portfolio1 p, p.positions.values order by p.ID", "select distinct p.iD, p.status from /portfolio1 p order by p.iD", "select distinct iD, status from /portfolio1 order by iD", "select distinct * from /portfolio1 p order by p.getID()", "select distinct * from /portfolio1 p order by p.getP1().secId", "select distinct  p.position1.secId  as st from /portfolio1 p order by p.position1.secId", "select distinct p, pos from /portfolio1 p, p.positions.values pos order by p.ID", "select distinct p, pos from /portfolio1 p, p.positions.values pos order by pos.secId", "select distinct status from /portfolio1 where ID > 0 order by status", "select distinct p.status as st from /portfolio1 p where ID > 0 and status = 'inactive' order by p.status", "select distinct p.position1.secId as st from /portfolio1 p where p.ID > 0 and p.position1.secId != 'IBM' order by p.position1.secId"};
        Object[][] r = new Object[queries.length][2];
        QueryService qs = CacheUtils.getQueryService();
        Position.resetCounter();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        AttributesFactory af = new AttributesFactory();
        af.setPartitionAttributes(paf.create());
        Region r1 = CacheUtils.createRegion((String)"portfolio1", (RegionAttributes)af.create(), (boolean)false);
        for (i = 0; i < 50; ++i) {
            r1.put((Object)("" + i), (Object)new Portfolio(i));
        }
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                r[i][0] = q.execute();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        this.createIndex("i1", IndexType.FUNCTIONAL, "p.status", "/portfolio1 p");
        this.createIndex("i2", IndexType.FUNCTIONAL, "p.ID", "/portfolio1 p");
        this.createIndex("i3", IndexType.FUNCTIONAL, "p.position1.secId", "/portfolio1 p");
        for (i = 0; i < queries.length; ++i) {
            q = null;
            try {
                q = CacheUtils.getQueryService().newQuery(queries[i]);
                CacheUtils.getLogger().info("Executing query: " + queries[i]);
                OrderByTestImplementation.QueryObserverImpl observer = new OrderByTestImplementation.QueryObserverImpl();
                QueryObserverHolder.setInstance((QueryObserver)observer);
                r[i][1] = q.execute();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)q.getQueryString());
            }
        }
        StructSetOrResultsSet ssOrrs = new StructSetOrResultsSet();
        ssOrrs.CompareQueryResultsWithoutAndWithIndexes(r, queries.length, true, queries);
    }

    @Test
    public void testOrderByWithNullValues() throws Exception {
        String[] queries = this.getQueriesForOrderByWithNullValues();
        Object[][] r = new Object[queries.length][2];
        QueryService qs = CacheUtils.getQueryService();
        int size = 9;
        int numNullValues = 3;
        Region r1 = this.createRegion("portfolio1", Portfolio.class);
        for (int i = 1; i <= 9; ++i) {
            Portfolio pf = new Portfolio(i);
            if (i <= 3) {
                pf.pkid = null;
                pf.status = "a" + i;
            }
            r1.put((Object)("" + i), (Object)pf);
        }
        Query q = null;
        SelectResults results = null;
        List list = null;
        String str = "";
        try {
            String pkid;
            int id;
            String pkid2;
            Portfolio p;
            int i;
            str = queries[0];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            r[0][0] = results;
            list = results.asList();
            for (i = 1; i <= 9; ++i) {
                p = (Portfolio)list.get(i - 1);
                if (i <= 3) {
                    Assert.assertNull((String)("Expected null value for pkid, p: " + String.valueOf(p)), (Object)p.pkid);
                    continue;
                }
                Assert.assertNotNull((String)"Expected not null value for pkid", (Object)p.pkid);
                if (p.pkid.equals("" + i)) continue;
                Assert.fail((String)" Value of pkid is not in expected order.");
            }
            str = queries[1];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= 9; ++i) {
                p = (Portfolio)list.get(i - 1);
                if (i <= 3) {
                    Assert.assertNull((String)"Expected null value for pkid", (Object)p.pkid);
                    continue;
                }
                Assert.assertNotNull((String)"Expected not null value for pkid", (Object)p.pkid);
                if (p.pkid.equals("" + i)) continue;
                Assert.fail((String)" Value of pkid is not in expected order.");
            }
            str = queries[2];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= 9; ++i) {
                p = (Portfolio)list.get(i - 1);
                if (i > 6) {
                    Assert.assertNull((String)"Expected null value for pkid", (Object)p.pkid);
                    continue;
                }
                Assert.assertNotNull((String)"Expected not null value for pkid", (Object)p.pkid);
                if (p.pkid.equals("" + (9 - (i - 1)))) continue;
                Assert.fail((String)" Value of pkid is not in expected order.");
            }
            str = queries[3];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= list.size(); ++i) {
                pkid2 = (String)list.get(i - 1);
                if (i == 1) {
                    Assert.assertNull((String)"Expected null value for pkid", (Object)pkid2);
                    continue;
                }
                Assert.assertNotNull((String)"Expected not null value for pkid", (Object)pkid2);
                if (pkid2.equals("" + (3 + (i - 1)))) continue;
                Assert.fail((String)" Value of pkid is not in expected order.");
            }
            str = queries[4];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= list.size(); ++i) {
                pkid2 = (String)list.get(i - 1);
                if (i == 1) {
                    Assert.assertNull((String)"Expected null value for pkid", (Object)pkid2);
                    continue;
                }
                Assert.assertNotNull((String)"Expected not null value for pkid", (Object)pkid2);
                if (pkid2.equals("" + (3 + (i - 1)))) continue;
                Assert.fail((String)" Value of pkid is not in expected order.");
            }
            str = queries[5];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= list.size(); ++i) {
                pkid2 = (String)list.get(i - 1);
                if (i == list.size()) {
                    Assert.assertNull((String)"Expected null value for pkid", (Object)pkid2);
                    continue;
                }
                Assert.assertNotNull((String)"Expected not null value for pkid", (Object)pkid2);
                if (pkid2.equals("" + (9 - (i - 1)))) continue;
                Assert.fail((String)" Value of pkid is not in expected order.");
            }
            str = queries[6];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= 9; ++i) {
                int id2 = (Integer)((Struct)list.get(i - 1)).getFieldValues()[0];
                if (i <= 3) {
                    if (id2 == 1 || id2 == 2 || id2 == 3) continue;
                    Assert.fail((String)(" Value of ID is not as expected " + id2));
                    continue;
                }
                if (id2 == i) continue;
                Assert.fail((String)(" Value of ID is not as expected " + id2));
            }
            str = queries[7];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= list.size(); ++i) {
                Struct vals = (Struct)list.get(i - 1);
                id = (Integer)vals.get("ID");
                pkid = (String)vals.get("pkid");
                if (i <= 3) {
                    Assert.assertNull((String)("Expected null value for pkid, " + pkid), (Object)pkid);
                    if (id == 1 || id == 2 || id == 3) continue;
                    Assert.fail((String)(" Value of ID is not as expected " + id));
                    continue;
                }
                if (!pkid.equals("" + i)) {
                    Assert.fail((String)(" Value of pkid is not as expected, " + pkid));
                }
                if (id == i) continue;
                Assert.fail((String)(" Value of ID is not as expected, " + id));
            }
            str = queries[8];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= list.size(); ++i) {
                Struct vals = (Struct)list.get(i - 1);
                id = (Integer)vals.get("ID");
                pkid = (String)vals.get("pkid");
                if (i <= 3) {
                    Assert.assertNull((String)("Expected null value for pkid, " + pkid), (Object)pkid);
                    if (id == i) continue;
                    Assert.fail((String)(" Value of ID is not as expected, it is: " + id + " expected :" + i));
                    continue;
                }
                if (!pkid.equals("" + i)) {
                    Assert.fail((String)(" Value of pkid is not as expected, " + pkid));
                }
                if (id == i) continue;
                Assert.fail((String)(" Value of ID is not as expected, " + id));
            }
            str = queries[9];
            q = CacheUtils.getQueryService().newQuery(str);
            CacheUtils.getLogger().info("Executing query: " + str);
            results = (SelectResults)q.execute();
            list = results.asList();
            for (i = 1; i <= list.size(); ++i) {
                Struct vals = (Struct)list.get(i - 1);
                id = (Integer)vals.get("ID");
                pkid = (String)vals.get("pkid");
                if (i <= 3) {
                    Assert.assertNull((String)("Expected null value for pkid, " + pkid), (Object)pkid);
                    if (id == 3 - (i - 1)) continue;
                    Assert.fail((String)(" Value of ID is not as expected " + id));
                    continue;
                }
                if (!pkid.equals("" + i)) {
                    Assert.fail((String)(" Value of pkid is not as expected, " + pkid));
                }
                if (id == i) continue;
                Assert.fail((String)(" Value of ID is not as expected, " + id));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)q.getQueryString());
        }
    }

    @Override
    public String[] getQueriesForOrderByWithNullValues() {
        String[] queries = new String[]{"SELECT  distinct * FROM /portfolio1 pf1 order by pkid", "SELECT  distinct * FROM /portfolio1 pf1  order by pkid asc", "SELECT  distinct * FROM /portfolio1 order by pkid desc", "SELECT  distinct pkid FROM /portfolio1 pf1 order by pkid", "SELECT  distinct pkid FROM /portfolio1 pf1 where pkid != 'XXXX' order by pkid asc", "SELECT  distinct pkid FROM /portfolio1 pf1 where pkid != 'XXXX' order by pkid desc", "SELECT  distinct ID, pkid FROM /portfolio1 pf1 where ID < 1000 order by pkid", "SELECT  distinct ID, pkid FROM /portfolio1 pf1 where ID > 0 order by pkid", "SELECT  distinct ID, pkid FROM /portfolio1 pf1 where ID > 0 order by pkid, ID asc", "SELECT  distinct ID, pkid FROM /portfolio1 pf1 where ID > 0 order by pkid, ID desc"};
        return queries;
    }

    @Override
    public String[] getQueriesForLimitNotAppliedIfOrderByNotUsingIndex() {
        String[] queries = new String[]{"SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid = '12' and ID > 10 order by ID desc, pkid asc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '1' and ID > 10 order by ID asc, pkid desc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid = '13'and  ID > 10 and ID < 20 order by ID asc, pkid asc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid <'9' and ID > 10 and ID < 20 order by ID desc , pkid desc", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid = '15' and ID >= 10 and ID <= 20 order by ID desc, pkid desc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '1' and pkid <='9' and ID >= 10 and ID <= 20 order by ID asc, pkid asc", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '1' and ID != 10 order by ID asc, pkid asc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '1' and ID != 10 order by ID desc, pkid desc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid = '17' and ID > 10 order by ID desc, pkid asc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '17' and ID > 10 order by ID asc, pkid desc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid < '7' and ID > 10 and ID < 20 order by ID asc, pkid asc limit 5 ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid = '18' and ID > 10 and ID < 20 order by ID desc, pkid desc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '1' and ID >= 10 and ID <= 20 order by ID desc, pkid asc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid != '17' and ID >= 10 and ID <= 20 order by ID asc, pkid desc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '0' and ID != 10 order by ID asc, pkid asc limit 10", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '1' and ID != 10 order by ID desc, pkid desc limit 10"};
        return queries;
    }

    @Override
    public String[] getQueriesForMultiColOrderByWithIndexResultWithProjection() {
        String[] queries = new String[]{"SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID > 10 order by ID desc, pkid desc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID > 10 order by ID asc, pkid asc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID asc, pkid asc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID desc , pkid desc", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID desc, pkid asc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID asc, pkid desc", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID != 10 order by ID asc , pkid desc", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID != 10 order by ID desc, pkid asc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID > 10 order by ID desc, pkid desc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID > 10 order by ID asc, pkid asc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID asc, pkid desc limit 5 ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID > 10 and ID < 20 order by ID desc, pkid asc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID desc, pkid desc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID >= 10 and ID <= 20 order by ID asc, pkid asc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID != 10 order by ID asc , pkid desc limit 10", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where ID != 10 order by ID desc, pkid desc limit 10"};
        return queries;
    }

    @Override
    public String[] getQueriesForMultiColOrderByWithMultiIndexResultProjection() {
        String[] queries = new String[]{"SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid = '12' and ID > 10 order by ID desc, pkid asc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '1' and ID > 10 order by ID asc, pkid desc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid = '13'and  ID > 10 and ID < 20 order by ID asc, pkid asc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid <'9' and ID > 10 and ID < 20 order by ID desc , pkid desc", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid = '15' and ID >= 10 and ID <= 20 order by ID desc, pkid desc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '1' and pkid <='9' and ID >= 10 and ID <= 20 order by ID asc, pkid asc", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '1' and ID != 10 order by ID asc, pkid asc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '1' and ID != 10 order by ID desc, pkid desc ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid = '17' and ID > 10 order by ID desc, pkid asc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '17' and ID > 10 order by ID asc, pkid desc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid < '7' and ID > 10 and ID < 20 order by ID asc, pkid asc limit 5 ", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid = '18' and ID > 10 and ID < 20 order by ID desc, pkid desc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '1' and ID >= 10 and ID <= 20 order by ID desc, pkid asc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid != '17' and ID >= 10 and ID <= 20 order by ID asc, pkid desc limit 5", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '0' and ID != 10 order by ID asc, pkid asc limit 10", "SELECT  distinct ID, description, createTime, pkid FROM /portfolio1 pf1 where pkid > '1' and ID != 10 order by ID desc, pkid desc limit 10"};
        return queries;
    }
}

