/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.geode.management.internal.security.AccessControlMXBean;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.junit.rules.ConnectionConfiguration;
import org.apache.geode.test.junit.rules.DescribedExternalResource;
import org.junit.Assert;
import org.junit.runner.Description;

public class MBeanServerConnectionRule
extends DescribedExternalResource {
    private Supplier<Integer> portSupplier;
    private JMXConnector jmxConnector;
    private MBeanServerConnection con;

    public MBeanServerConnectionRule() {
    }

    public MBeanServerConnectionRule(Supplier<Integer> portSupplier) {
        this.portSupplier = portSupplier;
    }

    protected void before(Description description) throws Exception {
        if (this.portSupplier == null) {
            return;
        }
        ConnectionConfiguration config = (ConnectionConfiguration)description.getAnnotation(ConnectionConfiguration.class);
        if (config == null) {
            return;
        }
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String user = config.user();
        String password = config.password();
        env.put("jmx.remote.credentials", new String[]{user, password});
        this.connect(null, this.portSupplier.get(), env);
    }

    protected void after(Description description) throws Exception {
        this.disconnect();
    }

    public <T> T getProxyMXBean(Class<T> proxyClass, String beanQueryName) throws MalformedObjectNameException, IOException {
        return JMX.newMXBeanProxy(this.con, this.getObjectName(proxyClass, beanQueryName), proxyClass);
    }

    public <T> T getProxyMBean(Class<T> proxyClass, String beanQueryName) throws IOException, MalformedObjectNameException {
        return JMX.newMBeanProxy(this.con, this.getObjectName(proxyClass, beanQueryName), proxyClass);
    }

    public <T> T getProxyMBean(Class<T> proxyClass) throws MalformedObjectNameException, IOException {
        return this.getProxyMBean(proxyClass, null);
    }

    private ObjectName getObjectName(Class<?> proxyClass, String beanQueryName) throws MalformedObjectNameException, IOException {
        ObjectName name = null;
        QueryExp query = null;
        if (proxyClass != null) {
            query = Query.isInstanceOf(Query.value(proxyClass.getName()));
        }
        if (beanQueryName != null) {
            name = ObjectName.getInstance(beanQueryName);
        }
        Set<ObjectInstance> beans = this.con.queryMBeans(name, query);
        Assert.assertEquals((String)("failed to find only one instance of type " + proxyClass.getName() + " with name " + beanQueryName), (long)1L, (long)beans.size());
        return ((ObjectInstance)beans.toArray()[0]).getObjectName();
    }

    public AccessControlMXBean getAccessControlMBean() throws Exception {
        return JMX.newMXBeanProxy(this.con, new ObjectName("GemFire:service=AccessControl,type=Distributed"), AccessControlMXBean.class);
    }

    public <T> T getProxyMXBean(Class<T> proxyClass) throws MalformedObjectNameException, IOException {
        return this.getProxyMXBean(proxyClass, null);
    }

    public <T> T getProxyMXBean(String beanQueryName) throws MalformedObjectNameException, IOException {
        return this.getProxyMXBean(null, beanQueryName);
    }

    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.con;
    }

    public void connect(int jmxPort) throws Exception {
        this.connect(null, jmxPort, null);
    }

    public void connect(int jmxPort, Map<String, ?> environment) throws Exception {
        this.connect(null, jmxPort, environment);
    }

    public void connect(String jmxServer, int jmxPort) throws Exception {
        this.connect(jmxServer, jmxPort, null);
    }

    public void connect(String jmxServer, int jmxPort, Map<String, ?> environment) throws Exception {
        if (jmxServer == null) {
            jmxServer = "";
        }
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + jmxServer + ":" + jmxPort + "/jmxrmi");
        GeodeAwaitility.await().until(() -> {
            HashMap env = new HashMap();
            if (environment != null) {
                env = new HashMap(environment);
            }
            try {
                this.jmxConnector = JMXConnectorFactory.connect(url, env);
            }
            catch (Exception e) {
                if (e.getMessage().contains("no such object in table")) {
                    return false;
                }
                throw e;
            }
            return true;
        });
        this.con = this.jmxConnector.getMBeanServerConnection();
    }

    public void disconnect() throws Exception {
        if (this.jmxConnector != null) {
            this.jmxConnector.close();
            this.con = null;
            this.jmxConnector = null;
        }
    }
}

