/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.geode.SystemFailure;
import org.apache.geode.test.dunit.internal.MethodInvokerResult;

class MethodInvoker {
    MethodInvoker() {
    }

    static MethodInvokerResult execute(String target, String methodName) {
        return MethodInvoker.execute(target, methodName, null);
    }

    static MethodInvokerResult execute(String target, String methodName, Object[] parameters) {
        try {
            Class<?> targetClass = Class.forName(target);
            try {
                Class[] paramTypes;
                if (parameters == null) {
                    paramTypes = new Class[]{};
                } else {
                    paramTypes = new Class[parameters.length];
                    for (int i = 0; i < parameters.length; ++i) {
                        paramTypes[i] = parameters[i] == null ? null : parameters[i].getClass();
                    }
                }
                Method method = MethodInvoker.getMethod(targetClass, methodName, paramTypes);
                method.setAccessible(true);
                Object result = method.invoke(targetClass, parameters);
                return new MethodInvokerResult(result);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException == null) {
                    return new MethodInvokerResult(null);
                }
                return new MethodInvokerResult(targetException);
            }
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            return new MethodInvokerResult(t);
        }
    }

    static MethodInvokerResult executeObject(Object target, String methodName) {
        return MethodInvoker.executeObject(target, methodName, null);
    }

    static MethodInvokerResult executeObject(Object target, String methodName, Object[] arguments) {
        try {
            Class<?> receiverClass = target.getClass();
            try {
                Class[] paramTypes;
                if (arguments == null) {
                    paramTypes = new Class[]{};
                } else {
                    paramTypes = new Class[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        paramTypes[i] = arguments[i] == null ? Object.class : arguments[i].getClass();
                    }
                }
                Method method = MethodInvoker.getMethod(receiverClass, methodName, paramTypes);
                method.setAccessible(true);
                Object result = method.invoke(target, arguments);
                return new MethodInvokerResult(result);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException == null) {
                    return new MethodInvokerResult(null);
                }
                return new MethodInvokerResult(targetException);
            }
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            return new MethodInvokerResult(t);
        }
    }

    private static Method getMethod(Class targetClass, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        String name;
        StringBuilder sb;
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (Class theClass = targetClass; theClass != null; theClass = theClass.getSuperclass()) {
            Method[] methods;
            block1: for (Method method : methods = theClass.getDeclaredMethods()) {
                Class<?>[] methodParameterTypes;
                if (!method.getName().equals(methodName) || (methodParameterTypes = method.getParameterTypes()).length != parameterTypes.length) continue;
                for (int j = 0; j < methodParameterTypes.length; ++j) {
                    if (parameterTypes[j] == null) {
                        if (!methodParameterTypes[j].isPrimitive()) continue;
                        continue block1;
                    }
                    if (methodParameterTypes[j].isAssignableFrom(parameterTypes[j])) continue;
                    Class<?> methodParameterType = methodParameterTypes[j];
                    Class parameterType = parameterTypes[j];
                    if (!methodParameterType.isPrimitive() || !(methodParameterType.equals(Boolean.TYPE) && parameterType.equals(Boolean.class) || methodParameterType.equals(Short.TYPE) && parameterType.equals(Short.class) || methodParameterType.equals(Integer.TYPE) && parameterType.equals(Integer.class) || methodParameterType.equals(Long.TYPE) && parameterType.equals(Long.class) || methodParameterType.equals(Float.TYPE) && parameterType.equals(Float.class) || methodParameterType.equals(Double.TYPE) && parameterType.equals(Double.class) || methodParameterType.equals(Character.TYPE) && parameterType.equals(Character.class)) && (!methodParameterType.equals(Byte.TYPE) || !parameterType.equals(Byte.class))) continue block1;
                }
                matchingMethods.add(method);
            }
            if (matchingMethods.size() > 0) break;
        }
        if (matchingMethods.isEmpty()) {
            sb = new StringBuilder();
            sb.append("Could not find method ");
            sb.append(methodName);
            sb.append(" with ");
            sb.append(parameterTypes.length);
            sb.append(" parameters [");
            for (int i = 0; i < parameterTypes.length; ++i) {
                name = parameterTypes[i] == null ? null : parameterTypes[i].getName();
                sb.append(name);
                if (i >= parameterTypes.length - 1) continue;
                sb.append(", ");
            }
            sb.append("] in class ");
            sb.append(targetClass.getName());
            throw new NoSuchMethodException(sb.toString());
        }
        if (matchingMethods.size() > 1) {
            sb = new StringBuilder();
            sb.append("Method is ambiguous ");
            sb.append(methodName);
            sb.append(" with ");
            sb.append(parameterTypes.length);
            sb.append(" parameters [");
            for (int i = 0; i < parameterTypes.length; ++i) {
                name = parameterTypes[i] == null ? null : parameterTypes[i].getName();
                sb.append(name);
                if (i >= parameterTypes.length - 1) continue;
                sb.append(", ");
            }
            sb.append("] in class ");
            sb.append(targetClass.getName());
            sb.append(" methods=").append(matchingMethods);
            throw new NoSuchMethodException(sb.toString());
        }
        return (Method)matchingMethods.get(0);
    }
}

