/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.test.dunit.Host;

public class NetworkUtils {
    protected NetworkUtils() {
    }

    public static String getIPLiteral() {
        try {
            return SocketCreator.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new Error("Problem determining host IP address", e);
        }
    }

    public static String getServerHostName() {
        String serverBindAddress = System.getProperty("gemfire.server-bind-address");
        return serverBindAddress != null ? serverBindAddress : NetworkUtils.getCanonicalHostName();
    }

    @Deprecated
    public static String getServerHostName(Host host) {
        String serverBindAddress = System.getProperty("gemfire.server-bind-address");
        return serverBindAddress != null ? serverBindAddress : host.getHostName();
    }

    private static String getCanonicalHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new UncheckedIOException(e);
        }
    }
}

