/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.geode.test.dunit.internal.InternalBlackboard;
import org.apache.geode.test.dunit.internal.InternalBlackboardImpl;

public class DUnitBlackboard {
    private InternalBlackboard blackboard = InternalBlackboardImpl.getInstance();

    public void initBlackboard() {
        try {
            this.blackboard.initBlackboard();
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }

    public void signalGate(String gateName) {
        try {
            this.blackboard.signalGate(gateName);
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }

    public void waitForGate(String gateName, long timeout, TimeUnit units) throws TimeoutException, InterruptedException {
        try {
            this.blackboard.waitForGate(gateName, timeout, units);
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }

    public void clearGate(String gateName) {
        try {
            this.blackboard.clearGate(gateName);
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }

    public boolean isGateSignaled(String gateName) {
        try {
            return this.blackboard.isGateSignaled(gateName);
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }

    public void setMailbox(String boxName, Object value) {
        try {
            this.blackboard.setMailbox(boxName, value);
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }

    public <T> T getMailbox(String boxName) {
        try {
            return this.blackboard.getMailbox(boxName);
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }
}

