/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.templates;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.operations.OperationContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.security.AccessControl;
import org.apache.geode.security.NotAuthorizedException;

public class DummyAuthorization
implements AccessControl {
    private Set allowedOps = new HashSet(20);
    private DistributedMember remoteMember;
    private LogWriter securityLogWriter;
    public static final OperationContext.OperationCode[] READER_OPS = new OperationContext.OperationCode[]{OperationContext.OperationCode.GET, OperationContext.OperationCode.QUERY, OperationContext.OperationCode.EXECUTE_CQ, OperationContext.OperationCode.CLOSE_CQ, OperationContext.OperationCode.STOP_CQ, OperationContext.OperationCode.REGISTER_INTEREST, OperationContext.OperationCode.UNREGISTER_INTEREST, OperationContext.OperationCode.KEY_SET, OperationContext.OperationCode.CONTAINS_KEY, OperationContext.OperationCode.EXECUTE_FUNCTION};
    public static final OperationContext.OperationCode[] WRITER_OPS = new OperationContext.OperationCode[]{OperationContext.OperationCode.PUT, OperationContext.OperationCode.PUTALL, OperationContext.OperationCode.DESTROY, OperationContext.OperationCode.INVALIDATE, OperationContext.OperationCode.REGION_CLEAR};

    public static AccessControl create() {
        return new DummyAuthorization();
    }

    public void init(Principal principal, DistributedMember remoteMember, Cache cache) throws NotAuthorizedException {
        String name;
        if (principal != null && (name = principal.getName().toLowerCase()) != null) {
            if (name.equals("root") || name.equals("admin") || name.equals("administrator")) {
                this.addReaderOps();
                this.addWriterOps();
                this.allowedOps.add(OperationContext.OperationCode.REGION_CREATE);
                this.allowedOps.add(OperationContext.OperationCode.REGION_DESTROY);
            } else if (name.startsWith("writer")) {
                this.addWriterOps();
            } else if (name.startsWith("reader")) {
                this.addReaderOps();
            }
        }
        this.remoteMember = remoteMember;
        this.securityLogWriter = cache.getSecurityLogger();
    }

    public boolean authorizeOperation(String regionName, OperationContext context) {
        OperationContext.OperationCode opCode = context.getOperationCode();
        this.securityLogWriter.fine("Invoked authorize operation for [" + opCode + "] in region [" + regionName + "] for client: " + this.remoteMember);
        return this.allowedOps.contains(opCode);
    }

    public void close() {
        this.allowedOps.clear();
    }

    private void addReaderOps() {
        for (int index = 0; index < READER_OPS.length; ++index) {
            this.allowedOps.add(READER_OPS[index]);
        }
    }

    private void addWriterOps() {
        for (int index = 0; index < WRITER_OPS.length; ++index) {
            this.allowedOps.add(WRITER_OPS[index]);
        }
    }
}

