/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.geode.management.internal.configuration.ClusterConfig;
import org.apache.geode.management.internal.configuration.ConfigGroup;
import org.apache.geode.management.internal.configuration.utils.ZipUtils;
import org.apache.geode.test.compiler.ClassBuilder;
import org.apache.geode.test.junit.rules.serializable.SerializableTemporaryFolder;
import org.junit.Before;
import org.junit.Rule;

public abstract class ClusterConfigTestBase {
    public String clusterConfigZipPath;
    public static final ConfigGroup CLUSTER = new ConfigGroup("cluster").regions(new String[]{"regionForCluster"}).jars(new String[]{"cluster.jar"}).maxLogFileSize("5000").configFiles(new String[]{"cluster.properties", "cluster.xml"});
    public static final ConfigGroup GROUP1 = new ConfigGroup("group1").regions(new String[]{"regionForGroup1"}).jars(new String[]{"group1.jar"}).maxLogFileSize("6000").configFiles(new String[]{"group1.properties", "group1.xml"});
    public static final ConfigGroup GROUP2 = new ConfigGroup("group2").regions(new String[]{"regionForGroup2"}).jars(new String[]{"group2.jar"}).maxLogFileSize("7000").configFiles(new String[]{"group2.properties", "group2.xml"});
    public static final ClusterConfig CONFIG_FROM_ZIP = new ClusterConfig(CLUSTER, GROUP1, GROUP2);
    public static final ClusterConfig REPLICATED_CONFIG_FROM_ZIP = new ClusterConfig(new ConfigGroup("cluster").maxLogFileSize("5000").jars(new String[]{"cluster.jar"}).regions(new String[]{"regionForCluster"}), new ConfigGroup("group1").maxLogFileSize("6000").jars(new String[]{"group1.jar"}).regions(new String[]{"regionForGroup1"}), new ConfigGroup("group2").maxLogFileSize("7000").jars(new String[]{"group2.jar"}).regions(new String[]{"regionForGroup2"}));
    @Rule
    public SerializableTemporaryFolder temporaryFolder = new SerializableTemporaryFolder();
    protected Properties locatorProps;
    protected Properties serverProps;

    @Before
    public void beforeClusterConfigTestBase() throws Exception {
        this.clusterConfigZipPath = this.buildClusterZipFile();
        this.locatorProps = new Properties();
        this.serverProps = new Properties();
        this.locatorProps.setProperty("enable-cluster-configuration", "true");
        this.serverProps.setProperty("use-cluster-configuration", "true");
    }

    private String buildClusterZipFile() throws Exception {
        File clusterConfigDir = this.temporaryFolder.newFolder("cluster_config");
        File clusterDir = new File(clusterConfigDir, "cluster");
        String clusterXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<cache xmlns=\"http://geode.apache.org/schema/cache\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" copy-on-read=\"false\" is-server=\"false\" lock-lease=\"120\" lock-timeout=\"60\" search-timeout=\"300\" version=\"1.0\" xsi:schemaLocation=\"http://geode.apache.org/schema/cache http://geode.apache.org/schema/cache/cache-1.0.xsd\">\n<region name=\"regionForCluster\">\n    <region-attributes data-policy=\"replicate\" scope=\"distributed-ack\"/>\n  </region>\n</cache>\n";
        this.writeFile(clusterDir, "cluster.xml", clusterXml);
        this.writeFile(clusterDir, "cluster.properties", "log-file-size-limit=5000");
        ClusterConfigTestBase.createJarFileWithClass("Cluster", "cluster.jar", clusterDir);
        File group1Dir = new File(clusterConfigDir, "group1");
        String group1Xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<cache xmlns=\"http://geode.apache.org/schema/cache\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" copy-on-read=\"false\" is-server=\"false\" lock-lease=\"120\" lock-timeout=\"60\" search-timeout=\"300\" version=\"1.0\" xsi:schemaLocation=\"http://geode.apache.org/schema/cache http://geode.apache.org/schema/cache/cache-1.0.xsd\">\n<region name=\"regionForGroup1\">\n    <region-attributes data-policy=\"replicate\" scope=\"distributed-ack\"/>\n  </region>\n</cache>\n";
        this.writeFile(group1Dir, "group1.xml", group1Xml);
        this.writeFile(group1Dir, "group1.properties", "log-file-size-limit=6000");
        ClusterConfigTestBase.createJarFileWithClass("Group1", "group1.jar", group1Dir);
        File group2Dir = new File(clusterConfigDir, "group2");
        String group2Xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<cache xmlns=\"http://geode.apache.org/schema/cache\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" copy-on-read=\"false\" is-server=\"false\" lock-lease=\"120\" lock-timeout=\"60\" search-timeout=\"300\" version=\"1.0\" xsi:schemaLocation=\"http://geode.apache.org/schema/cache http://geode.apache.org/schema/cache/cache-1.0.xsd\">\n<region name=\"regionForGroup2\">\n    <region-attributes data-policy=\"replicate\" scope=\"distributed-ack\"/>\n  </region>\n</cache>\n";
        this.writeFile(group2Dir, "group2.xml", group2Xml);
        this.writeFile(group2Dir, "group2.properties", "log-file-size-limit=7000");
        ClusterConfigTestBase.createJarFileWithClass("Group2", "group2.jar", group2Dir);
        File clusterConfigZip = new File(this.temporaryFolder.newFolder(), "cluster_config.zip");
        ZipUtils.zipDirectory((String)clusterConfigDir.getCanonicalPath(), (String)clusterConfigZip.getCanonicalPath());
        FileUtils.deleteDirectory((File)clusterConfigDir);
        return clusterConfigZip.getCanonicalPath();
    }

    private File writeFile(File dir, String fileName, String content) throws IOException {
        dir.mkdirs();
        File file = new File(dir, fileName);
        FileUtils.writeStringToFile((File)file, (String)content);
        return file;
    }

    protected static String createJarFileWithClass(String className, String jarName, File dir) throws IOException {
        File jarFile = new File(dir, jarName);
        new ClassBuilder().writeJarFromName(className, jarFile);
        return jarFile.getCanonicalPath();
    }
}

