/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache30;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache30.TestCacheCallback;

public abstract class TestCacheListener<K, V>
extends TestCacheCallback
implements CacheListener<K, V> {
    private final Object lock = new Object();
    private List<CacheEvent<K, V>> eventHistory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(CacheEvent<K, V> e, boolean setInvoked) {
        Object object = this.lock;
        synchronized (object) {
            if (setInvoked) {
                this.invoked = true;
            }
            if (this.eventHistory != null) {
                this.eventHistory.add(e);
            }
        }
    }

    private void addEvent(CacheEvent<K, V> e) {
        this.addEvent(e, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableEventHistory() {
        Object object = this.lock;
        synchronized (object) {
            if (this.eventHistory == null) {
                this.eventHistory = new ArrayList<CacheEvent<K, V>>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableEventHistory() {
        Object object = this.lock;
        synchronized (object) {
            this.eventHistory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CacheEvent<K, V>> getEventHistory() {
        Object object = this.lock;
        synchronized (object) {
            if (this.eventHistory == null) {
                return Collections.emptyList();
            }
            List<CacheEvent<K, V>> result = this.eventHistory;
            this.eventHistory = new ArrayList<CacheEvent<K, V>>();
            return result;
        }
    }

    public void afterCreate(EntryEvent<K, V> event) {
        this.addEvent((CacheEvent<K, V>)event);
        try {
            this.afterCreate2(event);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            this.callbackError = t;
        }
    }

    public void afterCreate2(EntryEvent<K, V> event) {
        String s = "Unexpected callback invocation";
        throw new UnsupportedOperationException(s);
    }

    public void afterUpdate(EntryEvent<K, V> event) {
        this.addEvent((CacheEvent<K, V>)event);
        try {
            this.afterUpdate2(event);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            this.callbackError = t;
        }
    }

    public void afterUpdate2(EntryEvent<K, V> event) {
        String s = "Unexpected callback invocation";
        throw new UnsupportedOperationException(s);
    }

    public void afterInvalidate(EntryEvent<K, V> event) {
        this.addEvent((CacheEvent<K, V>)event);
        try {
            this.afterInvalidate2(event);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            this.callbackError = t;
        }
    }

    public void afterInvalidate2(EntryEvent<K, V> event) {
        String s = "Unexpected callback invocation";
        throw new UnsupportedOperationException(s);
    }

    public void afterDestroy(EntryEvent<K, V> event) {
        this.afterDestroyBeforeAddEvent(event);
        this.addEvent((CacheEvent<K, V>)event);
        try {
            this.afterDestroy2(event);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            this.callbackError = t;
        }
    }

    public void afterDestroyBeforeAddEvent(EntryEvent<K, V> event) {
    }

    public void afterDestroy2(EntryEvent<K, V> event) {
        String s = "Unexpected callback invocation";
        throw new UnsupportedOperationException(s);
    }

    public void afterRegionInvalidate(RegionEvent<K, V> event) {
        this.addEvent((CacheEvent<K, V>)event);
        try {
            this.afterRegionInvalidate2(event);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            this.callbackError = t;
        }
    }

    public void afterRegionInvalidate2(RegionEvent<K, V> event) {
        String s = "Unexpected callback invocation";
        throw new UnsupportedOperationException(s);
    }

    public void afterRegionDestroy(RegionEvent<K, V> event) {
        if ("teardown".equals(event.getCallbackArgument())) {
            return;
        }
        this.afterRegionDestroyBeforeAddEvent(event);
        this.addEvent((CacheEvent<K, V>)event);
        try {
            this.afterRegionDestroy2(event);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            this.callbackError = t;
        }
    }

    public void afterRegionDestroyBeforeAddEvent(RegionEvent<K, V> ignored) {
    }

    public void afterRegionDestroy2(RegionEvent<K, V> event) {
        if (!event.getOperation().isClose()) {
            String s = "Unexpected callback invocation";
            throw new UnsupportedOperationException(s);
        }
    }

    public void afterRegionClear(RegionEvent<K, V> event) {
        this.addEvent((CacheEvent<K, V>)event, false);
    }

    public void afterRegionCreate(RegionEvent<K, V> event) {
        this.addEvent((CacheEvent<K, V>)event, false);
    }

    public void afterRegionLive(RegionEvent<K, V> event) {
        this.addEvent((CacheEvent<K, V>)event, false);
    }
}

