/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.SystemFailure;
import org.apache.geode.test.dunit.RMIException;

public class AsyncInvocation<V>
implements Future<V> {
    private static final long DEFAULT_JOIN_MILLIS = 60000L;
    private final Thread thread;
    private final AtomicReference<V> resultValue = new AtomicReference();
    private final AtomicReference<Throwable> resultThrowable = new AtomicReference();
    private Object target;
    private String methodName;
    private boolean cancelled;

    public AsyncInvocation(Object target, String methodName, Callable<V> work) {
        this.target = target;
        this.methodName = methodName;
        this.thread = new Thread(new AsyncInvocationGroup(), this.runnable(work), AsyncInvocation.getName(target, methodName));
    }

    public Object getTarget() {
        return this.target;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean exceptionOccurred() {
        return this.getException() != null;
    }

    public Throwable getException() {
        try {
            this.checkIsDone("Exception status not available while thread is alive.");
        }
        catch (IllegalStateException illegalStateException) {
            throw new AssertionError((Object)illegalStateException);
        }
        if (this.resultThrowable.get() instanceof RMIException) {
            return this.resultThrowable.get().getCause();
        }
        return this.resultThrowable.get();
    }

    public AsyncInvocation<V> checkException() {
        if (this.resultThrowable.get() != null) {
            throw new AssertionError("An exception occurred during asynchronous invocation.", this.getException());
        }
        return this;
    }

    public V getResult() throws InterruptedException {
        this.join();
        this.checkException();
        this.checkIsDone("Return value not available while thread is alive.");
        return this.resultValue.get();
    }

    public V getResult(long millis) throws InterruptedException {
        try {
            return this.get(millis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            throw new AssertionError((Object)executionException);
        }
        catch (TimeoutException timeoutException) {
            throw new AssertionError((Object)timeoutException);
        }
    }

    public V getReturnValue() {
        this.checkIsDone("Return value not available while thread is alive.");
        return this.resultValue.get();
    }

    public synchronized AsyncInvocation<V> join(long millis) throws InterruptedException {
        this.thread.join(millis);
        return this;
    }

    public synchronized AsyncInvocation<V> join(long millis, int nanos) throws InterruptedException {
        this.thread.join(millis, nanos);
        return this;
    }

    public AsyncInvocation<V> join() throws InterruptedException {
        this.join(60000L);
        return this;
    }

    public synchronized AsyncInvocation<V> start() {
        this.thread.start();
        return this;
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    public synchronized boolean isAlive() {
        return this.thread.isAlive();
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return !this.thread.isAlive();
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.thread.isAlive() && mayInterruptIfRunning) {
            this.cancelled = true;
            this.thread.interrupt();
            return true;
        }
        return false;
    }

    public AsyncInvocation<V> await(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        long millis = unit.toMillis(timeout);
        this.join(millis);
        this.timeoutIfAlive(millis);
        this.checkException();
        return this;
    }

    public AsyncInvocation<V> await() throws ExecutionException, InterruptedException {
        try {
            return this.await(60000L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            throw new AssertionError((Object)timeoutException);
        }
    }

    @Override
    public V get() throws ExecutionException, InterruptedException {
        try {
            return this.get(60000L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            throw new AssertionError((Object)timeoutException);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        long millis = unit.toMillis(timeout);
        this.join(millis);
        this.timeoutIfAlive(millis);
        this.checkException();
        return this.resultValue.get();
    }

    public long getId() {
        return this.thread.getId();
    }

    public String toString() {
        return "AsyncInvocation{target=" + this.target + ", methodName='" + this.methodName + '\'' + '}';
    }

    private AsyncInvocation<V> checkIsDone(String message) {
        if (this.thread.isAlive()) {
            throw new IllegalStateException(message);
        }
        return this;
    }

    private AsyncInvocation<V> timeoutIfAlive(long timeout) throws TimeoutException {
        if (this.thread.isAlive()) {
            throw new TimeoutException("Timed out waiting " + timeout + " milliseconds for AsyncInvocation to complete.");
        }
        return this;
    }

    private Runnable runnable(Callable<V> work) {
        return () -> {
            try {
                this.resultValue.set(work.call());
            }
            catch (Throwable throwable) {
                this.resultThrowable.set(throwable);
            }
        };
    }

    private static String getName(Object target, String methodName) {
        StringBuilder sb = new StringBuilder(methodName);
        sb.append(" invoked on ");
        if (target instanceof Class) {
            sb.append("class ");
            sb.append(((Class)target).getName());
        } else {
            sb.append("an instance of ");
            sb.append(target.getClass().getName());
        }
        return sb.toString();
    }

    private class AsyncInvocationGroup
    extends ThreadGroup {
        private AsyncInvocationGroup() {
            super("Async Invocations");
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof VirtualMachineError) {
                SystemFailure.setFailure((Error)((VirtualMachineError)throwable));
            }
            AsyncInvocation.this.resultThrowable.set(throwable);
        }
    }
}

