/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Properties;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.LocatorStarterRule;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class GcCommandDUnitTestBase {
    private static final String MANAGER_NAME = "Manager";
    private static final String SERVER1_NAME = "Server1";
    private static final String SERVER2_NAME = "Server2";
    private static final String GROUP0 = "Group0";
    private static final String GROUP1 = "Group1";
    private static final String GROUP2 = "Group2";
    protected static MemberVM locator;
    @ClassRule
    public static ClusterStartupRule clusterStartupRule;
    @ClassRule
    public static GfshCommandRule gfsh;

    @BeforeClass
    public static void setup() throws Exception {
        Properties managerProps = new Properties();
        managerProps.setProperty("name", MANAGER_NAME);
        managerProps.setProperty("groups", GROUP0);
        managerProps.setProperty("log-file", "someLog.log");
        locator = clusterStartupRule.startLocatorVM(0, l -> (LocatorStarterRule)((LocatorStarterRule)l.withHttpService()).withProperties(managerProps));
        Properties server1Props = new Properties();
        server1Props.setProperty("name", SERVER1_NAME);
        server1Props.setProperty("groups", GROUP1);
        clusterStartupRule.startServerVM(1, server1Props, locator.getPort());
        Properties server2Props = new Properties();
        server2Props.setProperty("name", SERVER2_NAME);
        server2Props.setProperty("groups", GROUP2);
        clusterStartupRule.startServerVM(2, server2Props, locator.getPort());
    }

    @Before
    public void before() throws Exception {
        gfsh.connectAndVerify(locator.getJmxPort(), GfshCommandRule.PortType.jmxManager, new String[0]);
    }

    @After
    public void after() throws Exception {
        gfsh.disconnect();
    }

    @Test
    public void testGCForGroup() {
        String gcCommand = "gc --group=Group0";
        gfsh.executeAndAssertThat(gcCommand).statusIsSuccess();
        Assertions.assertThat((String)gfsh.getGfshOutput()).contains(new CharSequence[]{MANAGER_NAME});
    }

    @Test
    public void testGCForMemberID() {
        String gcCommand = "gc --member=Manager";
        gfsh.executeAndAssertThat(gcCommand).statusIsSuccess();
        Assertions.assertThat((String)gfsh.getGfshOutput()).contains(new CharSequence[]{MANAGER_NAME});
    }

    @Test
    public void testGCForEntireCluster() {
        String command = "gc";
        gfsh.executeAndAssertThat(command).statusIsSuccess();
        String output = gfsh.getGfshOutput();
        Assertions.assertThat((String)output).contains(new CharSequence[]{SERVER1_NAME});
        Assertions.assertThat((String)output).contains(new CharSequence[]{SERVER2_NAME});
        Assertions.assertThat((String)output).doesNotContain(new CharSequence[]{MANAGER_NAME});
    }

    @Test
    public void testGCForInvalidMember() throws Exception {
        String gcCommand = "gc --member=NotAValidMember";
        CommandResult result = gfsh.executeCommand(gcCommand);
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)Result.Status.ERROR);
        Assertions.assertThat((String)gfsh.getGfshOutput()).contains(new CharSequence[]{"Member NotAValidMember could not be found."});
    }

    static {
        clusterStartupRule = new ClusterStartupRule();
        gfsh = new GfshCommandRule();
    }
}

