/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.geode.internal.lang.SystemPropertyHelper;
import org.apache.geode.test.junit.rules.DescribedExternalResource;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.runner.Description;

public class DiskDirRule
extends DescribedExternalResource {
    protected static final String BEFORE = "before";
    protected static final String AFTER = "after";
    protected static final String STARTING = "starting";
    protected final boolean initializeHelperRules;
    private final TemporaryFolder temporaryFolder;
    private final TestName testName;
    private String originalValue;

    public DiskDirRule() {
        this(new Builder());
    }

    public DiskDirRule(TemporaryFolder temporaryFolder) {
        this(new Builder().temporaryFolder(temporaryFolder));
    }

    public DiskDirRule(TestName testName) {
        this(new Builder().testName(testName));
    }

    public DiskDirRule(TemporaryFolder temporaryFolder, TestName testName) {
        this(new Builder().temporaryFolder(temporaryFolder).testName(testName));
    }

    public DiskDirRule(Builder builder) {
        this(builder.initializeHelperRules, builder.temporaryFolder, builder.testName);
    }

    protected DiskDirRule(boolean initializeHelperRules, TemporaryFolder temporaryFolder, TestName testName) {
        this.initializeHelperRules = initializeHelperRules;
        this.temporaryFolder = temporaryFolder;
        this.testName = testName;
    }

    protected void before(Description description) throws Exception {
        Optional value = SystemPropertyHelper.getProductStringProperty((String)"defaultDiskDirs");
        value.ifPresent(s -> {
            this.originalValue = s;
        });
        if (this.initializeHelperRules) {
            this.initializeHelperRules(description);
        }
        File diskDir = this.temporaryFolder.newFolder(this.getDiskDirName(this.getDiskDirName(description.getClassName())));
        System.setProperty("geode.defaultDiskDirs", diskDir.getAbsolutePath());
    }

    protected void initializeHelperRules(Description description) throws Exception {
        Method method;
        if (this.temporaryFolder != null) {
            method = TemporaryFolder.class.getDeclaredMethod(BEFORE, new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.temporaryFolder, new Object[0]);
        }
        if (this.testName != null) {
            method = TestName.class.getDeclaredMethod(STARTING, Description.class);
            method.setAccessible(true);
            method.invoke((Object)this.testName, description);
        }
    }

    protected void after(Description description) {
        if (this.originalValue == null) {
            System.clearProperty("geode.defaultDiskDirs");
        } else {
            System.setProperty("geode.defaultDiskDirs", this.originalValue);
        }
    }

    protected String getDiskDirName(String testClass) {
        return testClass + "_" + this.testName.getMethodName() + "-diskDirs";
    }

    protected String getTestClassName(Description description) {
        return description.getTestClass().getSimpleName();
    }

    protected void invokeTemporaryFolderBefore(TemporaryFolder temporaryFolder) {
        if (temporaryFolder != null) {
            this.invoke(TemporaryFolder.class, temporaryFolder, BEFORE);
        }
    }

    protected void invokeTestNameBefore(TestName testName) {
        if (testName != null) {
            this.invoke(TestName.class, testName, BEFORE);
        }
    }

    protected <V> V invoke(Class<?> targetClass, Object targetInstance, String methodName) {
        try {
            Method method = targetClass.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return (V)method.invoke(targetInstance, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new Error(e);
        }
    }

    public static class Builder {
        private boolean initializeHelperRules = true;
        private TemporaryFolder temporaryFolder = new TemporaryFolder();
        private TestName testName = new TestName();

        public Builder initializeHelperRules(boolean value) {
            this.initializeHelperRules = value;
            return this;
        }

        public Builder temporaryFolder(TemporaryFolder temporaryFolder) {
            this.temporaryFolder = temporaryFolder;
            return this;
        }

        public Builder testName(TestName testName) {
            this.testName = testName;
            return this;
        }

        public DiskDirRule build() {
            return new DiskDirRule(this);
        }
    }
}

